/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * misc.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: misc.h,v 1.10 2003/12/28 09:29:32 uid68112 Exp $
*/

#ifndef __MISC_H__
#define __MISC_H__

#include <glib.h>
/***********************************************************/
/* routine copiant par troncature une chaine de caracteres */
/***********************************************************/
void strncpy_max(char *destination, const char *source, int max_byte);

/************************************************************************/
/* check if the given pattern exists inside filename (case insensitive) */
/************************************************************************/
/* output: address of the pattern or NULL */
/******************************************/
char *my_strcasestr(GString *pattern, char *filename);

/***************************************************/
/* compute the size of a NULL terminated ptr array */
/***************************************************/
int size_of_null_array(void **array);

#define SIZE_OF_NULL_ARRAY_IS_4(array)		( (((array)[0])!=NULL) && (((array)[1])!=NULL) && (((array)[2])!=NULL) && (((array)[3])!=NULL) && (((array)[4])==NULL) )

/******************************************/
/* convert 2 ascii hexdigit into 1 guint8 */
/******************************************/
guint8 ascii2_to_bin1(unsigned char *asc);

/******************************************************/
/* create the given directory (it can start with a /) */
/******************************************************/
/* output: 0=ok else errno */
/***************************/
int recursive_mkdir(GString *directory_name);

/*********************************************/
/* check if the given program is in the path */
/*********************************************/
/* output: TRUE=yes, FALSE=no */
/******************************/
gboolean check_prog_in_path(const char *progname);

/***************************************************************/
/* check if named socket can be created in the given directory */
/***************************************************************/
/* input: directory= directory to check                */
/*        possible= name of a possibly existing socket */
/*        attempt= name of the socket to try to create */
/*******************************************************/
/* output: TRUE=usable, FALSE=pb */
/*********************************/
gboolean check_socket_creation_in_directory(const char *directory, const char *possible, const char *attempt);

/*************************************************/
/* convert a value into a "human readable" value */
/**************************************************************/
/* input: value= the value to process                         */
/*        scale= 1000 for normal values, 1024 for pow2 values */
/**************************************************************/
/* output: human readable string (to free) */
/*******************************************/
GString *value_to_readable(double value, double scale);

/****************************************************/
/* convert a duration into a "human readable" value */
/****************************************************/
/* input: duration */
/*******************************************/
/* output: human readable string (to free) */
/*******************************************/
GString *duration_to_readable(guint64 duration);

#endif
