<?php
/*
 * $Id: class.dbFaqquestions.inc.php,v 1.2.4.1 2003/05/30 03:56:39 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbFaqquestions extends dclDB
{
	var $questionid;
	var $seq;
	var $topicid;
	var $questiontext;
	var $createby;
	var $createon;
	var $modifyby;
	var $modifyon;
	var $active;

	function dbFaqquestions()
	{
           // Table Fields
		$this->fieldArray = array(
				'questionid',
				'seq',
				'topicid', 
				'questiontext', 
				'createby', 
				'createon', 
				'modifyby', 
				'modifyon', 
				'active');

           // Foreign keys
		$this->foreignKeys = array('faqanswers' => 'questionid');

		$this->cache = array();
		$this->cacheEnabled = false;

		$this->dclDB();
	}

	function Add()
	{
		$this->AdjustSeq($this->seq);

		$idSQL = $this->GetNewIDSQLForTable('faqquestions');
		$query = 'INSERT INTO faqquestions (';
		if ($idSQL != '')
			$query .= 'questionid,';
		$query .= 'seq,topicid,questiontext,createby,createon,active)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= $this->seq . ',';
		$query .= $this->topicid . ',';
		$query .= '\'' . $this->DBAddSlashes($this->questiontext) . '\',';
		$query .= $this->DBAddSlashes($this->createby) . ',';
		$query .= $this->GetDateSQL() . ',';
		$query .= '\'Y\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_FAQQUESTIONINSERTERR, $query) . '<BR>';
		}
	}

	function AdjustSeq($fromThisSeq, $editID = 0)
	{
		$query = "SELECT questionid FROM faqquestions WHERE seq=$fromThisSeq and topicid=" . $this->topicid;
		if ($editID > 0)
			$query .= " AND questionid != $editID";
		$this->Query($query);
           // There is one with this seq and not this ID, so adjust it
		if ($this->next_record())
		{
			$thisID = $this->f('questionid');
			$this->FreeResult();
			$this->AdjustSeq($fromThisSeq + 1);
			$query = "UPDATE faqquestions SET seq=seq+1 WHERE questionid=$thisID";
			$this->Execute($query);
		}
	}

	function Edit()
	{
		$this->AdjustSeq($this->seq, $this->questionid);

		$query = 'UPDATE faqquestions SET ';
		$query .= 'seq=' . $this->seq . ',';
		$query .= 'topicid=' . $this->topicid . ',';
		$query .= 'questiontext=\'' . $this->DBAddSlashes($this->questiontext) . '\',';
		$query .= 'modifyby=' . $this->modifyby . ',';
		$query .= 'modifyon=' . $this->GetDateSQL() . ',';
		$query .= 'active=\'' . $this->active . '\'';
		$query .= ' WHERE questionid=' . $this->questionid;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM faqquestions WHERE questionid=' . $this->questionid;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE faqquestions SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE questionid=' . $this->questionid;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->questionid = $this->f('questionid');
			$this->seq = $this->f('seq');
			$this->topicid = $this->f('topicid');
			$this->questiontext = trim($this->f('questiontext'));
			$this->createby = $this->f('createby');
			$this->createon = $this->FormatTimestampForDisplay($this->f('createon'));
			$this->modifyby = $this->f('modifyby');
			$this->modifyon = $this->FormatTimestampForDisplay($this->f('modifyon'));
			$this->active = $this->f('active');

			if ($this->cacheEnabled)
				$this->CacheRow($this->questionid);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT questionid, seq, topicid, questiontext, createby, ';
		$sql .= $this->ConvertTimestamp('createon', 'createon');
		$sql .= ', modifyby, ';
		$sql .= $this->ConvertTimestamp('modifyon', 'modifyon');
		$sql .= ", active FROM faqquestions WHERE questionid=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function LoadByFaqTopicID($id, $orderby = 'seq')
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT questionid, seq, topicid, questiontext, createby, ';
		$sql .= $this->ConvertTimestamp('createon', 'createon');
		$sql .= ', modifyby, ';
		$sql .= $this->ConvertTimestamp('modifyon', 'modifyon');
		$sql .= ", active FROM faqquestions WHERE topicid=$id";
		if ($orderby != '')
			$sql .= " ORDER BY $orderby";

		if (!$this->Query($sql))
			return -1;

		return 1;
	}

	function Clear()
	{
		$this->questionid = 0;
		$this->seq = 0;
		$this->topicid = 0;
		$this->questiontext = '';
		$this->createby = 0;
		$this->createon = '';
		$this->modifyby = 0;
		$this->modifyon = '';
		$this->active = '';
	}
}
?>
