<?php
/*
 * $Id: class.htmlProjectsform.inc.php,v 1.1.1.1.2.1.2.2 2003/04/20 01:00:17 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('prj');
LoadStringResource('wo');

class htmlProjectsform
{
	function Show($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		IncludeCalendar();

		$isEdit = is_object($obj);

		$Template = CreateTemplate(array('hForm' => 'htmlProjectsForm.tpl'));
		$Template->set_block('hForm', 'status', 'hStatus');
		$Template->set_block('hForm', 'xmltemplates', 'hXMLTemplates');
		$Template->set_block('hForm', 'xmltemplatejs', 'hXMLTemplatejs');
		$Template->set_var('hStatus', '');
		$Template->set_var('hXMLTemplates', '');
		$Template->set_var('hXMLTemplatejs', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$objPrj = CreateObject('dcl.htmlProjects');
		$objHTMLPersonnel = CreateObject('dcl.htmlPersonnel');
		$oStatus = CreateObject('dcl.htmlStatuses');
		if ($isEdit)
		{
			$Template->set_var('TXT_TITLE', STR_PRJ_EDIT);
			$Template->set_var('VAL_NAME', htmlspecialchars($obj->name));
			$Template->set_var('CMB_PARENTPRJ', $objPrj->GetCombo($obj->parentprojectid, 'parentprojectid', 0, 0, $obj->projectid));
			$Template->set_var('CMB_REPORTTO', $objHTMLPersonnel->GetCombo($obj->reportto, 'reportto'));
			$Template->set_var('CMB_STATUS', $oStatus->GetCombo($obj->status));
			$Template->set_var('VAL_PROJECTDEADLINE', $obj->projectdeadline);
			$Template->set_var('VAL_DESCRIPTION', htmlspecialchars($obj->description));
			$hiddenvars = GetHiddenVar('menuAction', 'boProjects.dbmodify');
			$hiddenvars .= GetHiddenVar('projectid', $obj->projectid);

			$Template->parse('hStatus', 'status');
		}
		else
		{
			$Template->set_var('TXT_TITLE', STR_PRJ_ADD);
			$Template->set_var('VAL_NAME', '');
			$Template->set_var('CMB_PARENTPRJ', $objPrj->GetCombo(0, 'parentprojectid'));
			$Template->set_var('CMB_REPORTTO', $objHTMLPersonnel->GetCombo($GLOBALS['DCLID'], 'reportto'));
			$Template->set_var('CMB_STATUS', $oStatus->GetCombo(1));
			$Template->set_var('VAL_PROJECTDEADLINE', '');
			$Template->set_var('VAL_DESCRIPTION', '');
			$hiddenvars = GetHiddenVar('menuAction', 'boProjects.dbnewproject');
		}

		$Template->set_var('HIDDEN_VARS', $hiddenvars);
		$Template->set_var('TXT_NAME', STR_PRJ_NAME);
		$Template->set_var('TXT_PARENTPRJ', STR_PRJ_PARENTPRJ);
		$Template->set_var('TXT_LEAD', STR_PRJ_LEAD);
		$Template->set_var('TXT_STATUS', STR_PRJ_STATUS);
		$Template->set_var('TXT_DEADLINE', STR_PRJ_DEADLINE);
		$Template->set_var('TXT_DESCRIPTION', STR_PRJ_DESCRIPTION);
		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_PRJ_HIGHLIGHTEDNOTE);

		if ($dcl_info['DCL_PROJECT_XML_TEMPLATES'] == 'Y' && !$isEdit)
		{
			$Template->set_var('TXT_USETMPL', STR_PRJ_USETMPL);
			$Template->set_var('TXT_TMPLPARAM', STR_PRJ_TMPLPARAM);
			$Template->set_var('TXT_TMPLVALUE', STR_PRJ_VALUE);
			$Template->set_var('TXT_NOTMPL', STR_PRJ_NOTMPL);

			$objXMLProject = CreateObject('dcl.xmlProjects');
			$objXMLProject->createCombo();
			$Template->set_var('CMB_XMLPROJECTS', $objXMLProject->comboHTML);
			$Template->parse('hXMLTemplates', 'xmltemplates');

			$Template->set_var('JS_TEMPLATE', $objXMLProject->comboJS);
			$Template->parse('hXMLTemplatejs', 'xmltemplatejs');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
