#ifndef __STATUS_H__
#define __STATUS_H__
/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * status.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: status.h,v 1.2 2003/12/28 08:12:38 uid68112 Exp $
*/

enum
{
	IS_OFFLINE=1,		/* client is not connected to the hub */
	IS_ONLINE=2,		/* client is connected to the hub */
};

/***********************************************/
/* set client status in the global status file */
/***********************************************/
void set_client_status(int status);

/**************************************************/
/* delete client status in the global status file */
/**************************************************/
void del_client_status(void);

/* the gstatus file has the following format: */
/* NB_LONG_PER_ENTRY (=32) * sizeof (unsigned long) byte per entry */
/* unsigned long[0]=pid of the process owning this entry (0=entry is empty) */
/* unsigned long[1]=hub connection status (==IS_OFFLINE or IS_ONLINE) */
/* unsigned long[2]=number of GDL */
/* unsigned long[3]=number of users on the hub (only significant when IS_ONLINE) */
/* unsigned long[4]=it is a bitfield */
/* unsigned long[5]=number of uploads */

typedef enum
{
	GSTATUS_PID=0,						/* unsigned long */
	GSTATUS_CNX_STATUS=1,			/* unsigned long */
	GSTATUS_NB_GDL=2,					/* unsigned long */
	GSTATUS_NB_USERS=3,				/* unsigned long */
	GSTATUS_FLAG1=4,					/* unsigned long */
	GSTATUS_NB_UL=5,					/* unsigned long */
} GSTATUS_POSITION_ENUM;

typedef union
{
	unsigned long int full;
	struct
	{
		unsigned int is_clock_master:1;	/* if ==1, this client is the clock master */
		unsigned int unused:31;		/* unused bits */
	} bf;
} FLAG1_STRUCT;

/*************************************************************************************************/
/* set the given value (unsigned long) at the given position of the client entry in gstatus file */
/*************************************************************************************************/
void set_client_unsigned_long_number(GSTATUS_POSITION_ENUM position, unsigned long value);

/*****************************************************************************************/
/* set the given value (float) at the given position of the client entry in gstatus file */
/*****************************************************************************************/
void set_client_float_number(GSTATUS_POSITION_ENUM position, float value);

#define SET_GSTATUS_GDL(num) set_client_unsigned_long_number(GSTATUS_NB_GDL,num)
#define SET_GSTATUS_USERS(num) set_client_unsigned_long_number(GSTATUS_NB_USERS,num)
#define SET_GSTATUS_FLAG1(num) set_client_unsigned_long_number(GSTATUS_FLAG1,num)
#define SET_GSTATUS_UL(num) set_client_unsigned_long_number(GSTATUS_NB_UL,num)

/*************************************************************************************************/
/* get the given value (unsigned long) at the given position of the client entry in gstatus file */
/* if the client has no entry on the gstatus file (this should never occurs), 0 is returned      */
/*************************************************************************************************/
unsigned long get_client_unsigned_long_number(GSTATUS_POSITION_ENUM position);

#define GET_GSTATUS_FLAG1() get_client_unsigned_long_number(GSTATUS_FLAG1)

#endif
