/** String of symbols.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include "symbolstring.h"
#include "tree.h"
#include "util.h"
#include <stdio.h>
#include <stdlib.h>


/** Sets this string to the specified input file. */
void
set_string( String* w, FILE* file, const Dictionary* symbols)
{
	w->next = w->second = NULL;
	w->file = file;
	w->symbols = symbols;
	w->line = w->column = 1;
}


/** Reads a symbol from this string. */
static Tree*
read_symbol( String* w)
{
	char* symbol = NULL;
	char* lexeme;
	char* p;
	fscanf( w->file, "%as \"", &symbol);
	lexeme = read_string( w->file, "\"");
	if( symbol == NULL || lexeme == NULL)
		return create_node( END);
	assumex( getc( w->file) == '"', "expected a closing quote");

	for( p = lexeme; *p; p++)
		count_lines_columns( &w->line, &w->column, *p);

	if( symbol[0] == '.') {
		// skip hidden symbols like comments and whitespace
		free( symbol);
		free( lexeme);
		return read_symbol( w);
	} else {
		int a = find( w->symbols, symbol);
		Tree* node = create_node( a);
		assumex( a != 0, "unknown symbol %s", symbol);
		free( symbol);
		node->count = 1;
		node->children[0] = create_node( (int)lexeme);
		return node;
	}
}


/** Returns the next symbol of this string. */
int
first( String* w)
{
	if( w->next == NULL)
		w->next = read_symbol( w);
	return w->next->data;
}


/** Removes the next symbol from this string. */
Tree*
next( String* w)
{

	Tree* a = w->next;
	w->next = w->second;
	w->second = NULL;
	return a;
}


/** Pushes the specified symbol onto the front of this string. */
void
push_symbol( String* w, Tree* a)
{
	w->second = w->next;
	w->next = a;
}
