/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void edit_inicializar(void)
{
	raiz_lista_archivos=NULL;
	edit_actual=NULL;
	edit_abriendo_llave=FALSE;
	edit_total_pestanas=1;
	edit_historico_funciones=NULL;
	edit_congelar_historico=TRUE;
}

void edit_inicializar_coloreado(void)
{
	GList *list;
	
	c_fondo.red=65535;
	c_fondo.green=65535;
	c_fondo.blue=65535;

	c_nada.red=0;
	c_nada.green=0;
	c_nada.blue=0;

	c_comentario.red=40000;
	c_comentario.green=40000;
	c_comentario.blue=40000;

	c_directiva.red=1000;
	c_directiva.green=45000;
	c_directiva.blue=1000;

	c_cadena_cs.red=65535;
	c_cadena_cs.green=40000;
	c_cadena_cs.blue=0;

	c_cadena_cd.red=65535;
	c_cadena_cd.green=20000;
	c_cadena_cd.blue=0;

	c_etiqueta.red=1000;
	c_etiqueta.green=1000;
	c_etiqueta.blue=50000;

	c_entero.red=50000;
	c_entero.green=1000;
	c_entero.blue=1000;

	c_real.red=40000;
	c_real.green=50000;
	c_real.blue=0;

	c_hexadecimal.red=60000;
	c_hexadecimal.green=0;
	c_hexadecimal.blue=60000;

	c_octal.red=50000;
	c_octal.green=40000;
	c_octal.blue=30000;
	
	c_prelight.red=0;
	c_prelight.green=0;
	c_prelight.blue=0;

	list=NULL;
	list=gtk_extext_highlight_pattern_entry_new(list,"directivas","^#[ \t]*\\(include\\|if\\|ifdef\\|ifndef\\|else\\|elif\\|define\\|endif\\|pragma\\)\\b",NULL,&c_directiva,NULL);
	list=gtk_extext_highlight_pattern_entry_new(list,"hexadecimal","\\b\\(0[xX][a-fA-F0-9][a-fA-F0-9]*\\)\\b",NULL,&c_hexadecimal,NULL);
	list=gtk_extext_highlight_pattern_entry_new(list,"real","\\b\\([0-9][0-9]*\\.[0-9][0-9]*\\)\\b",NULL,&c_real,NULL);
	list=gtk_extext_highlight_pattern_entry_new(list,"octal","\\b\\(0[0-7][0-7]*[1-7][0-7]*\\)\\b",NULL,&c_octal,NULL);
	list=gtk_extext_highlight_pattern_entry_new(list,"entero","\\b\\([0-9]*\\)\\b",NULL,&c_entero,NULL);
	list=gtk_extext_highlight_pattern_entry_new(list,"palabras_reservadas","\\b\\(void\\|char\\|short\\|int\\|long\\|float\\|double\\|unsigned\\|signed\\|typedef\\|enum\\|struct\\|const\\|switch\\|case\\|break\\|default\\|if\\|else\\|do\\|while\\|for\\|return\\|sizeof\\|static\\|inline\\|auto\\|continue\\|extern\\|goto\\|register\\|union\\|volatile\\)\\b",NULL,&c_etiqueta,NULL);
	list=gtk_extext_highlight_pattern_entry_new(list,"cadena_cs","\\(['][^\\'][']\\)\\|\\(['][\\][\\'0abcfnrtv][']\\)",NULL,&c_cadena_cs,NULL);
  
	edit_tabla_pattern=gtk_extext_highlight_pattern_table_new(list);
      
	list=NULL;                                          
	list=gtk_extext_highlight_syntax_entry_new(list,"cadena_cd","[^']\"","\"",NULL,&c_cadena_cd,NULL);
	list=gtk_extext_highlight_syntax_entry_new(list,"comentario","//","\n",NULL,&c_comentario,NULL);
	list=gtk_extext_highlight_syntax_entry_new(list,"comentario_multilinea","/\\*","\\*/",NULL,&c_comentario,NULL);

	edit_tabla_syntax=gtk_extext_highlight_syntax_table_new(list);
}

void edit_cerrar(void)
{
	struct s_lista_archivos *nodo;
	GList *lista;

	if (edit_tabla_syntax!=NULL) {
		gtk_extext_highlight_table_free(edit_tabla_syntax);
	edit_tabla_syntax=NULL;
	}
	if (edit_tabla_pattern!=NULL) {
		gtk_extext_highlight_table_free(edit_tabla_pattern);
		edit_tabla_pattern=NULL;
	}
	
	lista=cefv_lista_combo;
	while (lista!=NULL) {
		g_free(lista->data);
		lista=lista->next;
	}
	g_list_free(cefv_lista_combo);
	cefv_lista_combo=NULL;

	if (raiz_lista_archivos!=NULL) {
		nodo=raiz_lista_archivos;
		while (nodo->siguiente!=NULL) {
			nodo=nodo->siguiente;
		}
		while (nodo->anterior!=NULL) {
			cefv_eliminar_archivo(nodo->nombre);
			arch_eliminar(nodo->nombre);
			g_free(nodo->nombre);
			g_free(nodo->datos);
			nodo=nodo->anterior;
			g_free(nodo->siguiente);
		}
		cefv_eliminar_archivo(nodo->nombre);
		arch_eliminar(nodo->nombre);
		g_free(nodo->nombre);
		g_free(nodo->datos);
		g_free(nodo);
		raiz_lista_archivos=NULL;
	}
}

void edit_anadir(gchar *nombre,GtkCTreeNode *nodo_arbol)
{
	struct s_lista_archivos *nodo_lista;
	guint cont;
	FILE *archivo;
		
	DEBUG_MSG(->edit_anadir);
	if (raiz_lista_archivos==NULL) {
		raiz_lista_archivos=g_malloc(sizeof(struct s_lista_archivos));
		nodo_lista=raiz_lista_archivos;
		nodo_lista->anterior=NULL;
	} else {
		nodo_lista=raiz_lista_archivos;
		while (nodo_lista->siguiente!=NULL) {
			nodo_lista=nodo_lista->siguiente;
		}
		nodo_lista->siguiente=g_malloc(sizeof(struct s_lista_archivos));
		nodo_lista->siguiente->anterior=nodo_lista;
		nodo_lista=nodo_lista->siguiente;
	}
	nodo_lista->siguiente=NULL;
	nodo_lista->nodo_arbol=nodo_arbol;
	for (cont=0;nombre[cont]!=0;cont++);
	for (;nombre[cont]!='/';cont--);
	nodo_lista->nombre=g_strdup_printf("%s",&(nombre[cont+1]));
	nodo_lista->modificado=FALSE;
	nodo_lista->ajuste=0;
	nodo_lista->posicion=0;
	nodo_lista->editor=NULL;
	nodo_lista->pestana=-1;
	archivo=fopen(nombre,"r");
	fseek(archivo,0,SEEK_END);
	nodo_lista->size=ftell(archivo);
	fseek(archivo,0,SEEK_SET);
	nodo_lista->datos=g_malloc((nodo_lista->size)+1);
	fread(nodo_lista->datos,nodo_lista->size,1,archivo);
	fclose(archivo);
	(nodo_lista->datos)[nodo_lista->size]=0;
	cefv_analizar_archivo(nodo_lista->nombre);
	nodo_lista->filas=1;
	for (cont=0;cont<nodo_lista->size;cont++) {
		if ((nodo_lista->datos)[cont]=='\n') {
			(nodo_lista->filas)++;
		}
	}
	nodo_lista->limite_ajuste=(nodo_lista->filas)*14;
	nodo_lista->analizado=TRUE;
	DEBUG_MSG(<-edit_anadir);
}

void edit_guardar_todo(void)
{
	struct s_lista_archivos *nodo,*actual;
	FILE *archivo;
	gchar *nombre;
	
	actual=edit_actual;
	edit_actual=raiz_lista_archivos;
	while (edit_actual!=NULL) {
		if (edit_actual->pestana!=-1 && edit_actual->modificado) {
			edit_actualizar();
		}
		edit_actual=edit_actual->siguiente;
	}
	edit_actual=actual;
	nodo=raiz_lista_archivos;
	while (nodo!=NULL) {
		if (nodo->modificado) {
			nombre=pro_nombre_completo_archivo(nodo->nombre,FALSE);
			archivo=fopen(nombre,"w");
			fwrite(nodo->datos,nodo->size,1,archivo);
			fclose(archivo);
			nodo->modificado=FALSE;
			g_free(nombre);
		}
		nodo=nodo->siguiente;
	}
}

void edit_ver(gchar *nombre)
{
	GtkLabel *etiqueta;
	struct s_lista_archivos *nodo;
	GtkEditable *editor;

	DEBUG_MSG(->edit_ver);
	nodo=raiz_lista_archivos;
	while (g_strcasecmp(nodo->nombre,nombre)) {
		nodo=nodo->siguiente;
	}
	if (nodo->pestana!=-1) {
		edit_actual=nodo;
		DEBUG_MSG(<-edit_ver 1);
		return;
	}
	if (nodo->editor==NULL) {
		gtk_editable_set_editable(GTK_EDITABLE(edit_editor),TRUE);
		edit_actual=raiz_lista_archivos;
		while (edit_actual!=NULL && edit_actual->pestana!=0) {
			edit_actual=edit_actual->siguiente;
		}
		if (edit_actual!=NULL) {
			editor=GTK_EDITABLE(edit_editor);
			editor->selection_end_pos=editor->selection_start_pos;
			edit_actualizar();
			edit_actual->editor=NULL;
			edit_actual->pestana=-1;
			if (!edit_actual->analizado) {
				cefv_analizar_archivo(edit_actual->nombre);
				edit_actual->analizado=TRUE;
			}
		}
		nodo->pestana=0;
		nodo->editor=edit_editor;
	}
	edit_actual=NULL;
	edit_colorear(nodo);
	edit_actual=nodo;

	etiqueta=GTK_LABEL(lookup_widget(david_ventana,"editor_etiqueta"));
	gtk_label_set(etiqueta,nombre);
	edit_actualizar_fila();
	buscar_indice=0;
	buscar_terminado=FALSE;
	edit_abriendo_llave=FALSE;
	edit_mensaje("");
	DEBUG_MSG(<-edit_ver);
}

void edit_borrar_seleccion(void)
{
	GtkEditable *editor;

	if (edit_actual!=NULL) {
		editor=GTK_EDITABLE(edit_actual->editor);
		gtk_editable_delete_selection(editor);
	}
}

void edit_copiar_seleccion(void)
{
	GtkEditable *editor;

	if (edit_actual!=NULL) {
		editor=GTK_EDITABLE(edit_actual->editor);
		gtk_editable_copy_clipboard(editor);
	}
}

void edit_cortar_seleccion(void)
{
	GtkEditable *editor;

	if (edit_actual!=NULL) {
		editor=GTK_EDITABLE(edit_actual->editor);
		gtk_editable_cut_clipboard(editor);
	}
}

void edit_pegar_seleccion(void)
{
	GtkEditable *editor;

	if (edit_actual!=NULL) {
		editor=GTK_EDITABLE(edit_actual->editor);
		gtk_editable_paste_clipboard(editor);
	}
}

void edit_guardar(void)
{
	struct s_lista_archivos *nodo;
	FILE *archivo;
	gchar *nombre;
	
	if (edit_actual!=NULL) {
		edit_actualizar();
		nodo=edit_actual;
		if (nodo->modificado) {
			nombre=pro_nombre_completo_archivo(nodo->nombre,FALSE);
			archivo=fopen(nombre,"w");
			fwrite(nodo->datos,nodo->size,1,archivo);
			fclose(archivo);
			nodo->modificado=FALSE;
			g_free(nombre);
		}
	}
}

void edit_eliminar(gchar *nombre)
{
	GtkEditable *editor;
	GtkLabel *etiqueta;
	struct s_lista_archivos *nodo;
	GtkWidget *notebook;
	gint pestana_actual;

	nodo=edit_conseguir_nodo(nombre);
	editor=GTK_EDITABLE(nodo->editor);
	gtk_editable_delete_text(editor,0,-1);
	if (nodo->pestana==0) {
		etiqueta=GTK_LABEL(lookup_widget(david_ventana,"editor_etiqueta"));
		gtk_label_set(etiqueta,_("Files"));
	} else {
		pestana_actual=edit_actual->pestana;
		notebook=lookup_widget(david_ventana,"archivos_notebook");
		edit_actual->editor=NULL;
		edit_actual->pestana=-1;
		gtk_notebook_set_page(GTK_NOTEBOOK(notebook),0);
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),pestana_actual);
		edit_total_pestanas--;
		edit_actual=raiz_lista_archivos;
		while (edit_actual!=NULL) {
			if (edit_actual->pestana>pestana_actual) {
				edit_actual->pestana--;
			}
			edit_actual=edit_actual->siguiente;
		}
		edit_actual=raiz_lista_archivos;
		while (edit_actual!=NULL && edit_actual->pestana!=0) {
			edit_actual=edit_actual->siguiente;
		}
	}
	edit_actualizar_fila();

	if (nodo->siguiente!=NULL) {
		nodo->siguiente->anterior=nodo->anterior;
	}
	if (nodo->anterior!=NULL) {
		nodo->anterior->siguiente=nodo->siguiente;
	} else {
		raiz_lista_archivos=nodo->siguiente;
	}

	if (nodo==edit_actual) {
		edit_actual=NULL;
	}
	g_free(nodo->datos);
	g_free(nodo->nombre);
	g_free(nodo);
}

void edit_actualizar (void)
{
	GtkExText *editor;
	guint cont;

	DEBUG_MSG(->edit_actualizar);
	if (edit_actual!=NULL) {
		editor=edit_actual->editor;
		g_free(edit_actual->datos);
		edit_actual->datos=gtk_editable_get_chars(GTK_EDITABLE(editor),0,gtk_extext_get_length(editor));
		edit_actual->size=gtk_extext_get_length(editor);
		edit_actual->posicion=gtk_editable_get_position(GTK_EDITABLE(editor));
		edit_actual->ajuste=editor->vadj->value;
		edit_actual->limite_ajuste=editor->vadj->upper;
		edit_actual->filas=1;
		for (cont=0;cont<edit_actual->size;cont++) {
			if ((edit_actual->datos)[cont]=='\n') {
				(edit_actual->filas)++;
			}
		}
	}
	DEBUG_MSG(<-edit_actualizar);
}

void edit_actualizar_fila(void)
{
	GtkLabel *etiqueta;
	gchar *texto;
	guint fila;

	etiqueta=GTK_LABEL(lookup_widget(david_ventana,"fila_etiqueta"));

	if (edit_actual!=NULL) {
		fila=(edit_actual->editor->line_number)+1;
	} else {
		fila=0;
	}
	texto=g_strdup_printf(_("Row: %u"),fila);
	gtk_label_set(etiqueta,texto);
	g_free(texto);

}

void edit_auto_formato(GtkEditable *editor,gchar *texto,guint longitud,guint *posicion)
{
	gint cont;
	guint tabuladores;
	gchar *cadena,*tab1,*tab2;
	guint nueva_posicion;
	gint llaves;
	gint borrar1,borrar2;

	if ((texto[0]=='\n') && (longitud==1) && ((*posicion)!=1)) {
		edit_actualizar();
		cont=(*posicion)-2;
		while (((edit_actual->datos)[cont]!='\n') && (cont!=0)) {
			cont--;
		}
		tabuladores=0;
		cont++;
		while ((edit_actual->datos)[cont]==9) {
			tabuladores++;
			cont++;
		}
		if (((edit_actual->datos)[(*posicion)-2]=='{') && (edit_abriendo_llave) && (preferencias.completar_llaves)) {
			nueva_posicion=*posicion;
			if (tabuladores) {
				tab1=g_strnfill(tabuladores+1,9);
				tab2=g_strnfill(tabuladores,9);
				cadena=g_strdup_printf("%s\n%s}",tab1,tab2);
				gtk_editable_insert_text(editor,cadena,tabuladores+tabuladores+3,posicion);
				nueva_posicion+=(tabuladores+1);
				gtk_editable_set_position(editor,nueva_posicion);
				g_free(tab1);
				g_free(tab2);
				g_free(cadena);
			} else {
				tab1=g_strnfill(1,9);
				cadena=g_strdup_printf("%s\n}",tab1);
				gtk_editable_insert_text(editor,cadena,3,posicion);
				nueva_posicion++;
				gtk_editable_set_position(editor,nueva_posicion);
				g_free(tab1);
				g_free(cadena);
			}
		} else {
			if (((edit_actual->datos)[(*posicion)-2]=='{') && (preferencias.super_indentacion)) {
				tabuladores++;
			}
			if (((edit_actual->datos)[(*posicion)-2]==':') && (preferencias.super_indentacion)) {
				tabuladores++;
			}
			if ((tabuladores) && (preferencias.auto_indentacion)) {
				cadena=g_strnfill(tabuladores,9);
				gtk_editable_insert_text(editor,cadena,tabuladores,posicion);
				g_free(cadena);
			}
		}
	} else {
		if ((texto[0]=='}') && (longitud==1) && (preferencias.super_indentacion)) {
			edit_actualizar();
			cont=*posicion;
			tabuladores=0;
			if (cont>1) {
				cont-=2;
				while ((cont!=0) && ((edit_actual->datos)[cont]=='\t')) {
					cont--;
					tabuladores++;
				}
				if ((edit_actual->datos)[cont]!='\t') cont++;
			}
			if ((cont==0) || ((edit_actual->datos)[cont-1]=='\n')) {
				borrar1=cont;
				borrar2=cont+tabuladores;
				llaves=1;
				cont--;
				while ((cont>=0) && (llaves!=0)) {
					if ((edit_actual->datos)[cont]=='{') llaves--;
					if ((edit_actual->datos)[cont]=='}') llaves++;
					cont--;
				}
				if (llaves==0) {
					gtk_editable_delete_text(editor,borrar1,borrar2);
					(*posicion)=borrar1;
					edit_actualizar();
					while ((cont!=0) && ((edit_actual->datos)[cont]!='\n')) {
						cont--;
					}
					if ((edit_actual->datos)[cont]=='\n') cont++;
					tabuladores=0;
					while ((edit_actual->datos)[cont]==9) {
						tabuladores++;
						cont++;
					}
					tab1=NULL;
					cadena=NULL;
					if (tabuladores>0) {
						tab1=g_strnfill(tabuladores,9);
						cadena=g_strdup_printf("%s",tab1);
						gtk_editable_insert_text(editor,cadena,tabuladores,posicion);
					}
					(*posicion)++;
					gtk_editable_set_position(editor,*posicion);
					g_free(tab1);
					g_free(cadena);
				}
			}
		}
	}
	edit_abriendo_llave=FALSE;
	if ((texto[0]=='{') && (longitud==1)) {
		edit_abriendo_llave=TRUE;
	}
}

gboolean edit_comprobar_perdida_datos(void)
{
	struct s_lista_archivos *nodo;
	gboolean resultado;
	
	nodo=raiz_lista_archivos;
	resultado=FALSE;
	
	if (nodo!=NULL) {
		do {
			if (nodo->modificado) {
				resultado=TRUE;
			}
			nodo=nodo->siguiente;
		} while (nodo!=NULL);
	}
	return resultado;
}

void edit_mensaje(gchar *mensaje)
{
	GtkLabel *etiqueta;
	
	etiqueta=GTK_LABEL(lookup_widget(david_ventana,"mensajes_etiqueta"));
	gtk_label_set(etiqueta,mensaje);
}

void edit_ir_a_posicion(guint posicion,guint filas)
{
	gfloat superior;
	gfloat ajuste;
	guint fila;
	guint cont;
	
	fila=1;
	for (cont=0;cont<posicion;cont++) {
		if ((edit_actual->datos)[cont]==10) {
			fila++;
		}
	}
	if (fila>3) {
		fila-=2;
	} else {
		fila=1;
	}
	superior=edit_actual->editor->vadj->upper;
	ajuste=(((gfloat)fila)/((gfloat)filas))*superior;
	edit_actual->editor->vadj->value=ajuste;
	gtk_adjustment_value_changed(edit_actual->editor->vadj);
}

gboolean edit_repetido(gchar *nombre)
{
	struct s_lista_archivos *nodo;
	gboolean repe;
	
	repe=FALSE;
	nodo=raiz_lista_archivos;
	while (nodo!=NULL) {
		if (!strcmp(nodo->nombre,nombre)) {
			repe=TRUE;
		}
		nodo=nodo->siguiente;
	}
	return repe;
}

void edit_anadir_tabulacion(void)
{
	GtkEditable *editor;
	gchar *texto,*resultado;
	gint posicion;
	gchar **lineas;
	gchar *casi;
	gchar saltotab[3];
	gchar tab[2];
	
	saltotab[0]='\n';
	saltotab[1]=9;
	saltotab[2]=0;
	tab[0]=9;
	tab[1]=0;
	if (edit_actual!=NULL) {
		editor=GTK_EDITABLE(edit_actual->editor);
		gtk_extext_freeze(GTK_EXTEXT(editor));
		texto=edit_tabulacion(&posicion);
		if (texto != NULL) {
			lineas=g_strsplit(texto,"\n",0);
			casi=g_strjoinv(saltotab,lineas);
			resultado=g_strdup_printf("%s%s",tab,casi);
			gtk_editable_insert_text(editor,resultado,strlen(resultado),&posicion);
			g_free(texto);
			g_strfreev(lineas);
			g_free(resultado);
			g_free(casi);
		} //fin del if (texto != NULL)
		gtk_extext_thaw(GTK_EXTEXT(editor));
	} 
}

void edit_eliminar_tabulacion(void)
{
	GtkEditable *editor;
	gchar *texto,*resultado;
	gint posicion;
	gchar **lineas;
	guint cont;
	gboolean reemplazar;
	
	if (edit_actual!=NULL) {
		editor=GTK_EDITABLE(edit_actual->editor);
		gtk_extext_freeze(GTK_EXTEXT(editor));
		texto=edit_tabulacion(&posicion);
		if (texto != NULL) {
			lineas=g_strsplit(texto,"\n",0);
	
			reemplazar=TRUE;
			cont=0;
			while (lineas[cont]!=NULL) {
				if (lineas[cont][0]==9) {
					resultado=g_strdup(lineas[cont]+1);
					g_free(lineas[cont]);
					lineas[cont]=resultado;
				} else {
					reemplazar=FALSE;
				}
				cont++;
			}
			if (reemplazar) {
				resultado=g_strjoinv("\n",lineas);
				gtk_editable_insert_text(editor,resultado,strlen(resultado),&posicion);
			} else {
				gtk_editable_insert_text(editor,texto,strlen(texto),&posicion);
			}
			g_free(texto);
			g_strfreev(lineas);
		} //fin del if (texto != NULL)
		gtk_extext_thaw(GTK_EXTEXT(editor));	
	} //fin del if (edit_actual != NULL)
}

gchar *edit_tabulacion(gint *posicion)
{
	GtkEditable *editor;
	gchar *seleccion;
	guint inicio,fin;

	editor=GTK_EDITABLE(edit_actual->editor);
	inicio=editor->selection_start_pos;
	fin=editor->selection_end_pos;
	//Si hay texto seleccionado, entonces inicio < fin siempre. Si no habia ningun texto seleccionado, salimos
	if (inicio < fin) {
		edit_actualizar();
		for (;((edit_actual->datos)[inicio]!='\n') && (inicio!=0);inicio--);
		if ((edit_actual->datos)[inicio]=='\n') {
			inicio++;
		}
		seleccion=g_strndup((edit_actual->datos)+inicio,fin-inicio);
		gtk_editable_select_region(editor,inicio,fin);
		gtk_editable_delete_selection(editor);
		*posicion=inicio;
		return seleccion;
	} else {
		//no habia texto seleccionado, asi que devolvemos null y salimos
		*posicion = -1;
		return NULL;
	}
}

guint edit_ir_a_fila(guint fila,guint filas)
{
	gfloat superior;
	gfloat ajuste;
	guint cont;
	guint cont_f;

	cont_f=1;
	for (cont=0;cont_f<fila;cont++) {
		if (edit_actual->datos[cont]=='\n') {
			cont_f++;
		}
	}
	if (fila>3) {
		fila-=2;
	} else {
		fila=1;
	}
	superior=edit_actual->editor->vadj->upper;
	ajuste=(((gfloat)fila)/((gfloat)filas))*superior;
	edit_actual->editor->vadj->value=ajuste;
	gtk_adjustment_value_changed(edit_actual->editor->vadj);
	gtk_editable_set_position(GTK_EDITABLE(edit_actual->editor),cont);
	return cont;
}

void edit_colorear(struct s_lista_archivos *nodo)
{
	GtkExText *editor;
	guint tipo;
	guint pos;

	DEBUG_MSG(->edit_colorear);
	tipo=gen_tipo_archivo(nodo->nombre);
	editor=nodo->editor;
	gtk_extext_freeze(editor);
	gtk_editable_delete_text(GTK_EDITABLE(editor),0,gtk_extext_get_length(editor));
	pos=0;
	gtk_editable_insert_text(GTK_EDITABLE(editor),nodo->datos,nodo->size,&pos);
	if ((tipo==0) || (nodo->size==0)) {
		gtk_extext_highlight_set(GTK_EXTEXT_HIGHLIGHT(editor),FALSE);
	} else {
		gtk_extext_highlight_set(GTK_EXTEXT_HIGHLIGHT(editor),TRUE);
	}
	gtk_extext_thaw(editor);
	editor->vadj->value=nodo->ajuste;
	gtk_adjustment_value_changed(editor->vadj);
	gtk_editable_set_position(GTK_EDITABLE(editor),nodo->posicion);
	DEBUG_MSG(<-edit_colorear);
}

struct s_lista_archivos *edit_conseguir_nodo(gchar *nombre)
{
	struct s_lista_archivos *nodo;
	
	nodo=raiz_lista_archivos;
	while (strcmp(nodo->nombre,nombre)) {
		nodo=nodo->siguiente;
	}
	return nodo;
}

void edit_cambiar_reglas_coloreado(void)
{
	GList *list;
	gchar *libs;
	gchar *lenguaje;

	DEBUG_MSG(->edit_cambiar_reglas_coloreado);
	libs=pro_librerias_lincado();
	lenguaje=pro_lenguaje();

	if (edit_tabla_syntax!=NULL) {
		gtk_extext_highlight_table_free(edit_tabla_syntax);
		edit_tabla_syntax=NULL;
	}
	if (edit_tabla_pattern!=NULL) {
		gtk_extext_highlight_table_free(edit_tabla_pattern);
		edit_tabla_pattern=NULL;
	}

	list=NULL;
	list=gtk_extext_highlight_pattern_entry_new(list,"directivas","^#[ \t]*\\(include\\|if\\|ifdef\\|ifndef\\|else\\|elif\\|define\\|endif\\|pragma\\)\\b",NULL,&c_directiva,NULL);
	list=gtk_extext_highlight_pattern_entry_new(list,"hexadecimal","\\b\\(0[xX][a-fA-F0-9][a-fA-F0-9]*\\)\\b",NULL,&c_hexadecimal,NULL);
	list=gtk_extext_highlight_pattern_entry_new(list,"real","\\b\\([0-9][0-9]*\\.[0-9][0-9]*\\)\\b",NULL,&c_real,NULL);
	list=gtk_extext_highlight_pattern_entry_new(list,"octal","\\b\\(0[0-7][0-7]*[1-7][0-7]*\\)\\b",NULL,&c_octal,NULL);
	list=gtk_extext_highlight_pattern_entry_new(list,"entero","\\b\\([0-9]*\\)\\b",NULL,&c_entero,NULL);
	if ((libs!=NULL) && (libs[LGLIB]=='1')) {
		list=gtk_extext_highlight_pattern_entry_new(list,"tipos_glib","\\b\\(gint\\|gchar\\|gpointer\\|guint\\|guchar\\|gboolean\\|glong\\|gshort\\|gulong\\|gushort\\|gfloat\\|gdouble\\|gldouble\\|gint8\\|guint8\\|gint16\\|guint16\\|gint32\\|guint32\\)\\b",NULL,&c_etiqueta,NULL);
	}
	list=gtk_extext_highlight_pattern_entry_new(list,"palabras_reservadas","\\b\\(void\\|char\\|short\\|int\\|long\\|float\\|double\\|unsigned\\|signed\\|typedef\\|enum\\|struct\\|const\\|switch\\|case\\|break\\|default\\|if\\|else\\|do\\|while\\|for\\|return\\|sizeof\\|static\\|inline\\|auto\\|continue\\|extern\\|goto\\|register\\|union\\|volatile\\)\\b",NULL,&c_etiqueta,NULL);
	if ((lenguaje!=NULL) && (lenguaje[0]=='1')) {
		list=gtk_extext_highlight_pattern_entry_new(list,"palabras_reservadas_cpp","\\b\\(and\\|and_eq\\|asm\\|auto\\|bitand\\|bitor\\|bool\\|catch\\|class\\|compl\\|const_cast\\|continue\\|delete\\|dynamic_cast\\|explicit\\|false\\|friend\\|mutable\\|namespace\\|new\\|not\\|not_eq\\|operator\\|or\\|or_eq\\|pribate\\|protected\\|public\\|reinterpret_cast\\|static_cast\\|template\\|this\\|trow\\|true\\|try\\|typeid\\|typename\\|using\\|virtual\\|wchar_t\\|xor\\|xor_eq\\)\\b",NULL,&c_etiqueta,NULL);
	}
	list=gtk_extext_highlight_pattern_entry_new(list,"cadena_cs","\\(['][^\\'][']\\)\\|\\(['][\\][\\'0abcfnrtv][']\\)",NULL,&c_cadena_cs,NULL);

	edit_tabla_pattern=gtk_extext_highlight_pattern_table_new(list);
	
	g_free(lenguaje);
	g_free(libs);
      
	list=NULL;                                          
	list=gtk_extext_highlight_syntax_entry_new(list,"cadena_cd","[^']\"","\"",NULL,&c_cadena_cd,NULL);
	list=gtk_extext_highlight_syntax_entry_new(list,"comentario","//","\n",NULL,&c_comentario,NULL);
	list=gtk_extext_highlight_syntax_entry_new(list,"comentario_multilinea","/\\*","\\*/",NULL,&c_comentario,NULL);

	edit_tabla_syntax=gtk_extext_highlight_syntax_table_new(list);

	DEBUG_MSG(<-edit_cambiar_reglas_coloreado);
}

void edit_aplicar_reglas_coloreado(GtkExText *editor)
{
	DEBUG_MSG(->edit_aplicar_reglas_coloreado);

	gtk_extext_highlight_install_table(GTK_EXTEXT_HIGHLIGHT(editor),edit_tabla_pattern);
	gtk_extext_highlight_install_table(GTK_EXTEXT_HIGHLIGHT(editor),edit_tabla_syntax);
	
	DEBUG_MSG(<-edit_aplicar_reglas_coloreado);
}

void edit_recargar_archivo(gchar *nombre)
{
	struct s_lista_archivos *nodo, *edit_actual_tmp;
	gchar *nombre_completo;
	FILE *archivo;
	gint cont;
	
	nodo=edit_conseguir_nodo(nombre);
	nombre_completo=pro_nombre_completo_archivo(nombre,FALSE);

	nodo->modificado=FALSE;
	nodo->ajuste=0;
	nodo->posicion=0;
	archivo=fopen(nombre_completo,"r");
	fseek(archivo,0,SEEK_END);
	nodo->size=ftell(archivo);
	fseek(archivo,0,SEEK_SET);
	nodo->datos=g_malloc((nodo->size)+1);
	fread(nodo->datos,nodo->size,1,archivo);
	fclose(archivo);
	(nodo->datos)[nodo->size]=0;
	cefv_analizar_archivo(nodo->nombre);
	nodo->filas=1;
	for (cont=0;cont<nodo->size;cont++) {
		if ((nodo->datos)[cont]=='\n') {
			(nodo->filas)++;
		}
	}
	nodo->limite_ajuste=(nodo->filas)*14;
	nodo->analizado=TRUE;
	g_free(nombre_completo);
	if (nodo->pestana!=-1) {
		//Ponemos edit_actual a NULL para que no ejecute el codigo de la callback on_editor_texto_changed al ejecutar
		//la funcion edit_colorear
		edit_actual_tmp = edit_actual;
		edit_actual=NULL;
		edit_colorear(nodo);
		edit_actual = edit_actual_tmp;
	}
}

/************************************************************************************************************************************************
 * Muestra una funcion en la pestaa de funciones                                                                                                             *
 * El parametro actualziar_historico tiene que ser TRUE, excepto si se le llama dentro del callback del historico o del notebook   *
 ************************************************************************************************************************************************/
void edit_ver_funcion(gchar *funcion, gboolean actualizar_historico)
{
	gint fin;
	gint pos;
	gchar *datos,*copia_funcion;
	gint cont;
	struct s_lista_cefv *nodo;
	struct s_lista_archivos *archivo;
	gboolean salir;
	GtkNotebook *notebook;
	GtkCombo *historico_funciones;
	GList *nodo_historico;

	DEBUG_MSG(->edit_ver_funcion);
	//buscamos la funcion en el arbol cefv
	nodo=lista_cefv;
	salir=FALSE;
	while ((!salir) && (nodo!=NULL)) {
		if (strcasecmp(nodo->rama,funcion)!=0) {
			nodo=nodo->siguiente;
		} else {
			salir=TRUE;
		}
	};
	if (nodo==NULL) return;
	// ya tenemos el nodo del arbol correspondiente a la funcion buscada
	// ahora necesitamos el nodo de la lista de archivos
	archivo=edit_conseguir_nodo(nodo->archivo);
	if (archivo->pestana!=-1) {
		edit_actual=archivo;
		edit_actualizar();
	}
	edit_actual=NULL;
	datos=archivo->datos;
	datos=strstr(datos,nodo->definicion);
	if (datos==NULL) return;
	// ya tenemos el comienzo de la funcion. Ahora a buscar el final;
	fin=0;
	cont=0;
	// buscamos la primera llave
	for (;datos[fin]!='{';fin++);
	cont++;
	while (cont!=0) {
		fin++;
		switch (datos[fin]) {
			case '{':
				cont++;
				break;
			case '}':
				cont--;
				break;
		}
	}
	// ya tenemos el final de la funcion, ahora escribirlo en el widget
	gtk_editable_set_editable(GTK_EDITABLE(edit_funciones),TRUE);
	gtk_extext_freeze(edit_funciones);
	gtk_editable_delete_text(GTK_EDITABLE(edit_funciones),0,gtk_extext_get_length(edit_funciones));
	pos=0;
	gtk_editable_insert_text(GTK_EDITABLE(edit_funciones),datos,fin+1,&pos);
	gtk_extext_thaw(edit_funciones);
	gtk_editable_set_editable(GTK_EDITABLE(edit_funciones),FALSE);
	edit_funciones->vadj->value=0;
	gtk_adjustment_value_changed(edit_funciones->vadj);
	gtk_editable_set_position(GTK_EDITABLE(edit_funciones),0);

	if (actualizar_historico) {
		// actualizamos el historico	
		copia_funcion=g_strdup(funcion);
		edit_historico_funciones=g_list_prepend(edit_historico_funciones,copia_funcion);
		if (g_list_length(edit_historico_funciones)>10) {
			nodo_historico=g_list_last(edit_historico_funciones);
			g_free(nodo_historico->data);
			edit_historico_funciones=g_list_remove_link(edit_historico_funciones,nodo_historico);
			g_list_free_1(nodo_historico);
		}
		edit_congelar_historico=TRUE;
		historico_funciones=GTK_COMBO(lookup_widget(david_ventana,"historico_funciones_combo"));
		gtk_combo_set_popdown_strings(historico_funciones,edit_historico_funciones);
		edit_congelar_historico=FALSE;
		
		notebook=GTK_NOTEBOOK(lookup_widget(david_ventana,"archivos_notebook"));
		gtk_signal_handler_block_by_func(GTK_OBJECT(notebook),on_archivos_notebook_switch_page,NULL);
		gtk_notebook_set_page(notebook,1);
		gtk_signal_handler_unblock_by_func(GTK_OBJECT(notebook),on_archivos_notebook_switch_page,NULL);
	} //fin del if(actualizar_historico)
	DEBUG_MSG(<-edit_ver_funcion);
}
