

#include "textblock.h"
#include <stdint.h>

struct DVColor
{
	guint8 r, g, b, a;
};

TextBlock::TextBlock()
{
	pad = space = 0;
	align = 0;
	w = h = 0;
	fontmap = (PangoFT2FontMap*) pango_ft2_font_map_new();
	pango_ft2_font_map_set_resolution( fontmap, 72, 72 );
	context = pango_ft2_font_map_create_context( fontmap );
	layout = pango_layout_new( context );
}


TextBlock::~TextBlock()
{
    g_object_unref( layout );
    g_object_unref( context );
    g_object_unref( fontmap );
}

GdkPixbuf *TextBlock::getPixbuf( DVColor fg, DVColor bg )
{
	pango_layout_set_width( layout, /*720 * PANGO_SCALE*/ -1 ); // set wrapping constraints
	pango_layout_set_font_description( layout, font );
	pango_layout_set_spacing( layout, space );
	pango_layout_set_alignment( layout, static_cast< PangoAlignment >( align ) );
	pango_layout_set_markup( layout, text, (text == NULL ? 0 : strlen( text ) ) );
	pango_layout_get_pixel_size( layout, &w, &h );

	GdkPixbuf *pixbuf = gdk_pixbuf_new( GDK_COLORSPACE_RGB,
	                                    TRUE, /* has alpha */
	                                    8,
	                                    w + 2 * pad, h + 2 * pad );
	if ( pixbuf )
	{
		fillRectangle( pixbuf, bg );
		drawPixbuf( pixbuf, fg, bg );
	}
	
	return pixbuf;
}


void TextBlock::fillRectangle( GdkPixbuf *pixbuf, DVColor bg )
{
	int ww = gdk_pixbuf_get_width( pixbuf );
	int hh = gdk_pixbuf_get_height( pixbuf );
	uint8_t *p = gdk_pixbuf_get_pixels( pixbuf );

	for ( int j = 0; j < hh; j++ )
	{
		for ( int i = 0; i < ww; i++ )
		{
			*p++ = bg.r;
			*p++ = bg.g;
			*p++ = bg.b;
			*p++ = bg.a;
		}
	}
}


void TextBlock::drawPixbuf( GdkPixbuf *pixbuf, DVColor fg, DVColor bg )
{
	int x;
	int stride = gdk_pixbuf_get_rowstride( pixbuf );
	FT_Bitmap bitmap;
	
	bitmap.rows      = h;
	bitmap.width     = w;
	bitmap.pitch     = 32 * ( ( w + 31 ) / 31 );
	bitmap.buffer    = static_cast< unsigned char * >( calloc( 1, h * bitmap.pitch ) );
	bitmap.num_grays = 256;
	bitmap.pixel_mode = ft_pixel_mode_grays;

	pango_ft2_render_layout( &bitmap, layout, 0, 0 );
	
	uint8_t *src = bitmap.buffer;
	x = ( gdk_pixbuf_get_width( pixbuf ) - w - 2 * pad ) * align / 2 + pad;
	uint8_t *dest = gdk_pixbuf_get_pixels( pixbuf ) + 4 * x + pad * stride;
	for ( int j = 0; j < h; j++ )
	{
		uint8_t *d = dest;
		for ( int i = 0; i < w; i++ )
		{
			float a = ( float ) bitmap.buffer[ j * bitmap.pitch + i ] / 255.0;
			*d++ = ( int ) ( a * fg.r + ( 1 - a ) * bg.r );
			*d++ = ( int ) ( a * fg.g + ( 1 - a ) * bg.g );
			*d++ = ( int ) ( a * fg.b + ( 1 - a ) * bg.b );
			*d++ = ( int ) ( a * fg.a + ( 1 - a ) * bg.a );
		}
		dest += stride;
	}
	free( bitmap.buffer );
}




