#ifndef PDL_GEN_H
#define PDL_GEN_H

#include "deftbl.h"

#ifdef ELI_ARG
#undef ELI_ARG
#endif

#if defined(__STDC__) || defined(__cplusplus)
#define ELI_ARG(proto)    proto
#else
#define ELI_ARG(proto)    ()
#endif

#include "Coord.h"
#include "ProdElemList.h"
#include "deftbl.h"
#include "IntSet.h"
#include "err.h"
#include "IntSet.h"
#include "err.h"
#include "CoordCmp.h"

#define TYPE int
extern TYPE Getint ELI_ARG((int _Property, DefTableKey key, TYPE deflt));
extern void Setint ELI_ARG((int _Property, DefTableKey key, TYPE _add, TYPE _replace));
extern void Resetint ELI_ARG((int _Property, DefTableKey key, TYPE _val));
extern TYPE SetGetint ELI_ARG((int _Property, DefTableKey key, TYPE init, TYPE reset));
#undef TYPE
#define TYPE ProdElemList
extern TYPE GetProdElemList ELI_ARG((int _Property, DefTableKey key, TYPE deflt));
extern void SetProdElemList ELI_ARG((int _Property, DefTableKey key, TYPE _add, TYPE _replace));
extern void ResetProdElemList ELI_ARG((int _Property, DefTableKey key, TYPE _val));
#undef TYPE
#define TYPE DefTableKey
extern TYPE GetDefTableKey ELI_ARG((int _Property, DefTableKey key, TYPE deflt));
extern void SetDefTableKey ELI_ARG((int _Property, DefTableKey key, TYPE _add, TYPE _replace));
extern void ResetDefTableKey ELI_ARG((int _Property, DefTableKey key, TYPE _val));
#undef TYPE
#define TYPE CoordRef
extern TYPE GetCoordRef ELI_ARG((int _Property, DefTableKey key, TYPE deflt));
extern void SetCoordRef ELI_ARG((int _Property, DefTableKey key, TYPE _add, TYPE _replace));
extern void ResetCoordRef ELI_ARG((int _Property, DefTableKey key, TYPE _val));
#undef TYPE
#define TYPE IntSet
extern TYPE GetIntSet ELI_ARG((int _Property, DefTableKey key, TYPE deflt));
extern void SetIntSet ELI_ARG((int _Property, DefTableKey key, TYPE _add, TYPE _replace));
extern void ResetIntSet ELI_ARG((int _Property, DefTableKey key, TYPE _val));
extern TYPE InsertIntSet ELI_ARG((int _Property, DefTableKey key, int val));
extern TYPE UnionIntSet ELI_ARG((int _Property, DefTableKey key, TYPE val));
extern TYPE IntersectIntSet ELI_ARG((int _Property, DefTableKey key, TYPE val));
#undef TYPE

#define SetClpValue(key, _add, _replace)   \
		Setint(1, (key), (_add), (_replace))
#define ResetClpValue(key, _val)   \
		Resetint(1, (key), (_val))
#define GetClpValue(key, deflt)   \
		Getint(1, (key), (deflt))
#define SetProd(key, _add, _replace)   \
		SetProdElemList(2, (key), (_add), (_replace))
#define ResetProd(key, _val)   \
		ResetProdElemList(2, (key), (_val))
#define GetProd(key, deflt)   \
		GetProdElemList(2, (key), (deflt))
#define SetDiffProd(key, _add, _replace)   \
		Setint(3, (key), (_add), (_replace))
#define ResetDiffProd(key, _val)   \
		Resetint(3, (key), (_val))
#define GetDiffProd(key, deflt)   \
		Getint(3, (key), (deflt))
#define SetLhsProd(key, _add, _replace)   \
		SetDefTableKey(4, (key), (_add), (_replace))
#define ResetLhsProd(key, _val)   \
		ResetDefTableKey(4, (key), (_val))
#define GetLhsProd(key, deflt)   \
		GetDefTableKey(4, (key), (deflt))
#define SetErrLhsProd(key, _add, _replace)   \
		Setint(5, (key), (_add), (_replace))
#define ResetErrLhsProd(key, _val)   \
		Resetint(5, (key), (_val))
#define GetErrLhsProd(key, deflt)   \
		Getint(5, (key), (deflt))
#define SetCoord(key, _add, _replace)   \
		SetCoordRef(6, (key), (_add), (_replace))
#define ResetCoord(key, _val)   \
		ResetCoordRef(6, (key), (_val))
#define GetCoord(key, deflt)   \
		GetCoordRef(6, (key), (deflt))
#define SetSym(key, _add, _replace)   \
		Setint(7, (key), (_add), (_replace))
#define ResetSym(key, _val)   \
		Resetint(7, (key), (_val))
#define GetSym(key, deflt)   \
		Getint(7, (key), (deflt))
#define SetNextRule(key, _add, _replace)   \
		SetDefTableKey(8, (key), (_add), (_replace))
#define ResetNextRule(key, _val)   \
		ResetDefTableKey(8, (key), (_val))
#define GetNextRule(key, deflt)   \
		GetDefTableKey(8, (key), (deflt))
#define IntersectKindSet(key, val)   \
		IntersectIntSet(9, (key), (val))
#define UnionKindSet(key, val)   \
		UnionIntSet(9, (key), (val))
#define InsertKindSet(key, val)   \
		InsertIntSet(9, (key), (val))
#define SetKindSet(key, _add, _replace)   \
		SetIntSet(9, (key), (_add), (_replace))
#define ResetKindSet(key, _val)   \
		ResetIntSet(9, (key), (_val))
#define GetKindSet(key, deflt)   \
		GetIntSet(9, (key), (deflt))
#define InsertPrdKindSet(key, val)   \
		InsertIntSet(10, (key), (val))
#define UnionPrdKindSet(key, val)   \
		UnionIntSet(10, (key), (val))
#define SetPrdKindSet(key, _add, _replace)   \
		SetIntSet(10, (key), (_add), (_replace))
#define ResetPrdKindSet(key, _val)   \
		ResetIntSet(10, (key), (_val))
#define GetPrdKindSet(key, deflt)   \
		GetIntSet(10, (key), (deflt))
#define SetGetFirstOcc(key, init, reset)   \
		SetGetint(11, (key), (init), (reset))
#define SetFirstOcc(key, _add, _replace)   \
		Setint(11, (key), (_add), (_replace))
#define ResetFirstOcc(key, _val)   \
		Resetint(11, (key), (_val))
#define GetFirstOcc(key, deflt)   \
		Getint(11, (key), (deflt))

extern struct PropList PDLk[];


extern DefTableKey CloneKey ELI_ARG((DefTableKey key));
/* Clone a definition
 *    On entry-
 *       key=a valid definition
 *    On exit-
 *       CloneKey=Unique definition with the same properties
 *                and property values as key
 ***/

#ifdef MONITOR
extern void pdl_mon_properties ELI_ARG((DefTableKey));
#endif

#endif
