/* Emcast - Endhost multicast library
 * Copyright (C) 2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */


#include "util.h"
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <errno.h>

#include <stdio.h>


ssize_t
readn (int fd, void* buf, size_t len)
{
  size_t nleft;
  ssize_t nread;
  char* ptr;

  nleft = len;
  ptr = buf;
  while (nleft > 0)
    {
      if ((nread = read(fd, ptr, nleft)) < 0)
	{
	  if (errno == EINTR)
	    nread = 0;
	  else
	    return -1;
	}
      else if (nread == 0)  
	break;			/* EOF */

      nleft -= nread;
      ptr += nread;
    }

  #if 0
  {
    int i;
    if (nleft != 0)
      fprintf (stderr, "NLEFT != 0\n");
    fprintf (stderr, "%d readn %d: ", getpid(), len - nleft);
    for (i = 0; i < (len - nleft); ++i)
      fprintf (stderr, "%d ", ((char*) buf)[i]);
    fprintf (stderr, "\n");
  }
  #endif

  return (len - nleft);
}


ssize_t
writen (int fd, const void* buf, size_t len)
{
  size_t nleft;
  ssize_t nwritten;
  char* ptr;

  #if 0
  {
    int i;
    fprintf (stderr, "%d writen %d: ", getpid(), len);
    for (i = 0; i < len; ++i)
      fprintf (stderr, "%d ", ((char*)buf)[i]);
    fprintf (stderr, "\n");
  }
  #endif

  nleft = len;
  ptr = (char*) buf;
  while (nleft > 0)
    {
      if ((nwritten = write(fd, ptr, nleft)) < 0)
	{
	  if (errno == EINTR)
	    nwritten = 0;
	  else
	    return -1;
	}
      
      nleft -= nwritten;
      ptr += nwritten;
    }

  return len;
}


char*   
strndup (const char* str, size_t n)
{
  int len;
  char* d;
  int i;

  if (!str || !n)
    return NULL;

  for (len = 0; len < n && str[len] != '\0'; ++len)
    ;

  d = (char*) malloc (len+1);
  if (!d) return NULL;

  for (i = 0; i < len; ++i)
    d[i] = str[i];
  d[len] = '\0';

  return d;
}
