#!/bin/sh
#
# This file creates a w32 binary release
#
VERSION=0.81
STRIP=i586-mingw32msvc-strip
DDIR="`pwd`/Enigma-$VERSION"
SDIR=../

function cptext
{
    perl ./nlcvt.pl unix2dos $SDIR/$1 >$DDIR/$2
}

function cpfile
{
	cp $SDIR/$1 $DDIR/$2
}

#
# Copy levels
#
function copy_levels
{
    mkdir $DDIR/data/levels
    cp -p $SDIR/data/levels/*.{png,txt,lua} $DDIR/data/levels
    for folder in `(cd $SDIR/data/levels && ls -F)| grep / | grep -v CVS`; do 
	mkdir $DDIR/data/levels/$folder; 
	cp -p $SDIR/data/levels/$folder/*.{png,lua,txt} $DDIR/data/levels/$folder
    done
}

function copy_data
{
    mkdir $DDIR/data
    cp -p $SDIR/data/*.lua $DDIR/data/
    mkdir $DDIR/data/gfx
    cp -p $SDIR/data/gfx/*.png $DDIR/data/gfx
    copy_levels
    mkdir $DDIR/data/fonts
    cp -p $SDIR/data/fonts/*.{bmf,png,txt} $DDIR/data/fonts
    mkdir $DDIR/data/sound 
    cp -p $SDIR/data/sound/*.{wav,s3m} $DDIR/data/sound
}

#
# Copy documentation files
#
function copy_doc
{
    mkdir $DDIR/doc
    cptext README 		README.txt
    cptext NEWS 		NEWS.txt
    cptext COPYING 		doc/COPYING.txt
    cptext CHANGES 		doc/CHANGES.txt
    cptext etc/README-SDL.txt 	doc/README-SDL.txt
    cptext doc/ant_lua.txt 	doc/ant_lua.txt
    cpfile doc/refman/enigma-ref.html doc/
    cpfile doc/functions.html	doc/
    cpfile doc/functions.css	doc/
}

#
# Copy user manual
#
function copy_manual
{
    mkdir $DDIR/manual $DDIR/manual/images
    cpfile doc/manual/images/*.png manual/images
    cpfile doc/manual/*.html manual
}

################
# Build Enigma #
################
(cd .. ; make all)

###################
# Copy everything #
###################
rm -rf $DDIR
mkdir $DDIR

copy_data
copy_manual
copy_doc

cp -p $SDIR/src/enigma.exe $DDIR/enigma.exe
cp *.dll $DDIR/
$STRIP "$DDIR/enigma.exe"
upx $DDIR/enigma.exe

rm -f Enigma-w32-$VERSION.zip
zip -r Enigma-w32-$VERSION.zip "Enigma-$VERSION"
rm -rf $DDIR
