#ifndef _FTTOOLS_SWAB_H_
#define _FTTOOLS_SWAB_H_

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <sys/types.h>

/* stolen from linux/include/byteorder/swab.h */

/* casts are necessary for constants, because we never know how for sure
 * how U/UL/ULL map to u_int16_t, u_int32_t, u_int64_t. At least not in a portable way.
 */
#define swab16(x)					\
((u_int16_t)(						\
    (((u_int16_t)(x) & (u_int16_t)0x00ffU) << 8) |	\
    (((u_int16_t)(x) & (u_int16_t)0xff00U) >> 8) ))
#define swab32(x)						\
((u_int32_t)(							\
    (((u_int32_t)(x) & (u_int32_t)0x000000ffUL) << 24) |	\
    (((u_int32_t)(x) & (u_int32_t)0x0000ff00UL) <<  8) |	\
    (((u_int32_t)(x) & (u_int32_t)0x00ff0000UL) >>  8) |	\
    (((u_int32_t)(x) & (u_int32_t)0xff000000UL) >> 24) ))
#define swab64(x)							      \
((u_int64_t)(								      \
    (u_int64_t)(((u_int64_t)(x) & (u_int64_t)0x00000000000000ffULL) << 56) |  \
    (u_int64_t)(((u_int64_t)(x) & (u_int64_t)0x000000000000ff00ULL) << 40) |  \
    (u_int64_t)(((u_int64_t)(x) & (u_int64_t)0x0000000000ff0000ULL) << 24) |  \
    (u_int64_t)(((u_int64_t)(x) & (u_int64_t)0x00000000ff000000ULL) <<  8) |  \
    (u_int64_t)(((u_int64_t)(x) & (u_int64_t)0x000000ff00000000ULL) >>  8) |  \
    (u_int64_t)(((u_int64_t)(x) & (u_int64_t)0x0000ff0000000000ULL) >> 24) |  \
    (u_int64_t)(((u_int64_t)(x) & (u_int64_t)0x00ff000000000000ULL) >> 40) |  \
    (u_int64_t)(((u_int64_t)(x) & (u_int64_t)0xff00000000000000ULL) >> 56) ))

#if WORDS_BIGENDIAN
# define le16_to_cpu(n) swab16(n)
# define le32_to_cpu(n) swab32(n)
# define le64_to_cpu(n) swab64(n)
# define cpu_to_le16(n) swab16(n)
# define cpu_to_le32(n) swab32(n)
# define cpu_to_le64(n) swab64(n)
#else
# define le16_to_cpu(n) (n)
# define le32_to_cpu(n) (n)
# define le64_to_cpu(n) (n)
# define cpu_to_le16(n) (n)
# define cpu_to_le32(n) (n)
# define cpu_to_le64(n) (n)
#endif

#endif

/*
 * Local variables:
 *  version-control: t
 *  kept-new-versions: 5
 *  c-basic-offset: 4
 * End:
 */
