# Module: ftape-command.tcl
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

# module contents
global moduleList
global autoLoadList
set moduleList(ftape-command.tcl) { VFrame.frame5 TapeCmd ListCmdHandler CmdInList}
set autoLoadList(ftape-command.tcl) {1}

# procedures to show toplevel windows


# User defined procedures


# Procedure: VFrame.frame5
proc VFrame.frame5 { insertWidgetPath args} {

  set xfCounter 0
  set xfLength [llength $args]
  while {$xfCounter < $xfLength} {
    set xfElement [lindex $args $xfCounter]
    if {"$xfElement" == "-startupSrc" ||
        "$xfElement" == "-middleSrc" ||
        "$xfElement" == "-endSrc"} {
      if {$xfLength > [expr $xfCounter+1]} {
        incr xfCounter
        set xfSource($xfElement) [lindex $args $xfCounter]
      }
    } {
      if {[string match -* $xfElement]} {
        if {$xfLength > [expr $xfCounter+1]} {
          incr xfCounter
          set xfGenResource($xfElement) [lindex $args $xfCounter]
        }
      } {
        if {[string match $insertWidgetPath* $xfElement]} {
          if {$xfLength > [expr $xfCounter+2]} {
            incr xfCounter
            set xfSpecResource($xfElement) [lindex $args $xfCounter]
            incr xfCounter
            lappend xfSpecResource($xfElement) [lindex $args $xfCounter]
          }
        }
      }
    }
    incr xfCounter
  }

  if {"[info commands $insertWidgetPath]" == ""} {
  if {[info exists xfSource(-startupSrc)]} {
    if {[catch "$xfSource(-startupSrc) $insertWidgetPath" xfResult]} {
      puts stderr $xfResult
    }
  }
  set widgetCode {

  # build widget $insertWidgetPath.frame5
  frame $insertWidgetPath.frame5  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget $insertWidgetPath.frame5.frame
  frame $insertWidgetPath.frame5.frame

  # build widget $insertWidgetPath.frame5.frame.scrollbar3
  scrollbar $insertWidgetPath.frame5.frame.scrollbar3  -command {$insertWidgetPath.frame5.frame.listbox1 xview}  -orient {horizontal}  -relief {raised}

  # build widget $insertWidgetPath.frame5.frame.scrollbar2
  scrollbar $insertWidgetPath.frame5.frame.scrollbar2  -command {$insertWidgetPath.frame5.frame.listbox1 yview}  -relief {raised}

  # build widget $insertWidgetPath.frame5.frame.listbox1
  listbox $insertWidgetPath.frame5.frame.listbox1  -relief {raised}  -xscrollcommand {$insertWidgetPath.frame5.frame.scrollbar3 set}  -yscrollcommand {$insertWidgetPath.frame5.frame.scrollbar2 set} -height {17} -width {54}

  # pack master $insertWidgetPath.frame5.frame
  pack configure $insertWidgetPath.frame5.frame.scrollbar2  -fill y  -side right
  pack configure $insertWidgetPath.frame5.frame.listbox1  -expand 1  -fill both
  pack configure $insertWidgetPath.frame5.frame.scrollbar3  -fill x  -side bottom
  }
  set subst ""
  append subst \\ [string trim { $insertWidgetPath.frame5 }]
  regsub -all $subst $widgetCode $insertWidgetPath widgetCode
  regsub -all {%ThisTopWidget} $widgetCode $insertWidgetPath widgetCode
  eval $widgetCode

  if {[info exists xfSource(-middleSrc)]} {
    if {[catch "$xfSource(-middleSrc) $insertWidgetPath" xfResult]} {
      puts stderr $xfResult
    }
  }
  set geometryCode {

  # pack master $insertWidgetPath.frame5
  pack configure $insertWidgetPath.frame5.frame  -expand 1  -fill both

  # pack slave $insertWidgetPath.frame5
  pack configure $insertWidgetPath.frame5  -expand 1  -fill both
  }
  set subst ""
  append subst \\ [string trim { $insertWidgetPath.frame5 }]
  regsub -all $subst $geometryCode $insertWidgetPath geometryCode
  regsub -all {\$insertWidgetPath} $geometryCode [winfo parent $insertWidgetPath] geometryCode
  eval $geometryCode

  if {[info exists xfSource(-endSrc)]} {
    if {[catch "$xfSource(-endSrc) $insertWidgetPath" xfResult]} {
      puts stderr $xfResult
    }
  }
  }

  if {[info exists xfGenResource]} {
    set xfWidgetList ""
    set xfTmpWidgetList $insertWidgetPath
    while {1} {
      if {[llength $xfTmpWidgetList] == 0} {
        break
      }
      set xfFirstWidget [lindex $xfTmpWidgetList 0]
      lappend xfWidgetList $xfFirstWidget
      set xfTmpWidgetList [lreplace $xfTmpWidgetList 0 0]
      if {"[winfo children $xfFirstWidget]" != ""} {
        eval lappend xfTmpWidgetList [winfo children $xfFirstWidget]
      }
    }
    foreach xfCounter $xfWidgetList {
      if {[info exists xfGenResource]} {
        foreach xfResource [array names xfGenResource] {
          catch "$xfCounter config $xfResource [set xfGenResource($xfResource)]"
        }
      }
    }
  }
  if {[info exists xfSpecResource]} {
    foreach xfCounter [array names xfSpecResource] {
      if {"[info commands $xfCounter]" != ""} {
        catch "$xfCounter config [lindex $xfSpecResource($xfCounter) 0] [lindex $xfSpecResource($xfCounter) 1]"
      }
    }
  }

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree $insertWidgetPath"
    after 2 "catch {XFEditSetShowWindows}"
  }
  return $insertWidgetPath
}


# Procedure: TapeCmd
proc TapeCmd { {tapedev "/dev/nqft0"} {action_arg "status"} FDName} {
    global outputframe
    upvar \#0 $FDName fd

    set action [lindex [split $action_arg] 0]

    set ButtonMap(status)  Status
    set ButtonMap(rewind)  Rewind
    set ButtonMap(reten)   Retension
    set ButtonMap(erase)   Erase
    set ButtonMap(rewoffl) Eject
    set ButtonMap(reset)   Reset
    set ButtonMap(load)    Load
    set ButtonMap(setpart) SetPart

    if {[lindex [[SN $ButtonMap($action)Button] config -text] 4] == "Cancel"} {
	if {$fd != ""} {
	    CloseFD $FDName 1
	}
	UpdateTapeButtons $ButtonMap($action) "stop"
	return
    }

    UpdateTapeButtons $ButtonMap($action) "start"   
    catch {destroy $outputframe}
    VFrame.frame5 .frame5
    set outputframe [SN cmdframe]
    VFrame[SN cmdframe] [SN cmdframe]
    ClearList [SN cmdframe].frame.listbox1
#    puts "[SN cmdframe]\n"
    catch {CmdInList [SN cmdframe].frame.listbox1  "ftmt -f $tapedev $action_arg" $ButtonMap($action) $FDName}
}


# Procedure: ListCmdHandler
proc ListCmdHandler { listWidget Button FDName} {
    upvar \#0 $FDName fd

    set cmdline {}
    if {[catch {gets $fd cmdline} err]} {
	CloseFD $FDName 1
	exec sync
	FileInList $listWidget "/tmp/ftape-tool.[pid]"
	UpdateTapeButtons $Button "stop"
	return
    }
    if {[eof $fd]} {
	CloseFD $FDName 0
	UpdateTapeButtons $Button "stop"
	catch {FileInList $listWidget "/tmp/ftape-tool.[pid]"}
	return
    }
    $listWidget insert end $cmdline
    update
}


# Procedure: CmdInList
proc CmdInList { listWidget {cmd "ftmt -f /dev/nqft0 status"} Button FDName} {
    global cmdstatus
    upvar \#0 $FDName fd

#    puts "FD: $fd\n"
    set cmdstatus $cmd
#    tkwait visibility $listWidget
    update
    if {[catch {open "|$cmd 2> /tmp/ftape-tool.[pid]" RDONLY} fd]} {
	foreach fileLine [split $fd "\n"] {
	    $listWidget insert end $fileLine
	}
	catch {FileInList $listWidget "/tmp/ftape-tool.[pid]"}
	UpdateTapeButtons $Button "stop"
	set fd ""
	return
    }
    catch { fconfigure $fd -blocking 0 }
    fileevent $fd readable [list ListCmdHandler $listWidget $Button $FDName]
}


# Internal procedures

# eof
#

