/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: TimeDialog.cpp,v 1.11 2004/06/17 06:37:01 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "FWBTree.h"
#include "TimeDialog.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/Interval.h"

#include <qlineedit.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qdatetimeedit.h>
#include <qlabel.h>
#include <qspinbox.h>

#include <iostream>

using namespace libfwbuilder;
using namespace std;

void TimeDialog::loadFWObject(FWObject *o)
{
    obj=o;
    Interval *s = dynamic_cast<Interval*>(obj);
    assert(s!=NULL);

    init=true;

    fillLibraries(libs,obj);

    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

    switch (startDate->order())
    {
    case QDateEdit::MDY:
        startDateLabel->setText( tr("Date (M/D/Y):") );
        endDateLabel->setText(   tr("Date (M/D/Y):") );
        break;

    case QDateEdit::DMY:
        startDateLabel->setText( tr("Date (D/M/Y):") );
        endDateLabel->setText(   tr("Date (D/M/Y):") );
        break;

    case QDateEdit::YMD:
        startDateLabel->setText( tr("Date (Y/M/D):") );
        endDateLabel->setText(   tr("Date (Y/M/D):") );
        break;

    case QDateEdit::YDM:
        startDateLabel->setText( tr("Date (Y/D/M):") );
        endDateLabel->setText(   tr("Date (Y/D/M):") );
        break;

    }

    startTime->setTime( QTime( obj->getInt("from_hour"),
                               obj->getInt("from_minute") ) );

    int y=obj->getInt("from_year");
    int m=obj->getInt("from_month");
    int d=obj->getInt("from_day");
    startDate->setDate( (y<0 && m<0 && d<0)?QDate():QDate( y, m, d ) );

    startDOW->setValue( obj->getInt("from_weekday") );

    endTime->setTime( QTime( obj->getInt("to_hour"),
                             obj->getInt("to_minute") ) );

    y=obj->getInt("to_year");
    m=obj->getInt("to_month");
    d=obj->getInt("to_day");
    endDate->setDate( (y<0 && m<0 && d<0)?QDate():QDate( y, m, d ) );

    endDOW->setValue( obj->getInt("to_weekday") );


    apply->setEnabled( false );


    obj_name->setEnabled(!o->isReadOnly());
    setDisabledPalette(obj_name);

    libs->setEnabled(!o->isReadOnly());
    setDisabledPalette(libs);

    comment->setReadOnly(o->isReadOnly());
    setDisabledPalette(comment);

    startTime->setEnabled(!o->isReadOnly());
    setDisabledPalette(startTime);

    startDate->setEnabled(!o->isReadOnly());
    setDisabledPalette(startDate);

    startDOW->setEnabled(!o->isReadOnly());
    setDisabledPalette(startDOW);

    endTime->setEnabled(!o->isReadOnly());
    setDisabledPalette(endTime);

    endDate->setEnabled(!o->isReadOnly());
    setDisabledPalette(endDate);

    endDOW->setEnabled(!o->isReadOnly());
    setDisabledPalette(endDOW);


    init=false;
}
    
void TimeDialog::changed()
{
    apply->setEnabled( true );
}

void TimeDialog::validate(bool *res)
{
    *res=true;
}

void TimeDialog::isChanged(bool *res)
{
    *res=(!init && apply->isEnabled());
}

void TimeDialog::libChanged()
{
    changed();
}

void TimeDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;

    string oldname=obj->getName();
    obj->setName( string(obj_name->text().utf8()) );
    obj->setComment( string(comment->text().utf8()) );

    obj->setInt( "from_minute"   ,   startTime->time().minute());
    obj->setInt( "from_hour"  ,      startTime->time().hour()  );
    obj->setInt( "from_day"   ,      startDate->date().day()   );
    obj->setInt( "from_month" ,      startDate->date().month() );
    obj->setInt( "from_year"  ,      startDate->date().year()  );
    obj->setInt( "from_weekday" ,    startDOW->value()         );

    obj->setInt( "to_minute"   ,     endTime->time().minute()  );
    obj->setInt( "to_hour"  ,        endTime->time().hour()    );
    obj->setInt( "to_day"   ,        endDate->date().day()     );
    obj->setInt( "to_month" ,        endDate->date().month()   );
    obj->setInt( "to_year"  ,        endDate->date().year()    );
    obj->setInt( "to_weekday" ,      endDOW->value()           );

    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));

    init=true;

/* move to another lib if we have to */
    if (! FWBTree::isSystem(obj) && libs->currentText() != QString(obj->getLibrary()->getName().c_str()))
        om->moveObject(libs->currentText(), obj);

    init=false;

    apply->setEnabled( false );
}

void TimeDialog::discardChanges()
{
    loadFWObject(obj);
}

/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void TimeDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

