/*

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: newHostDialog.h,v 1.2 2004/06/13 22:15:36 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __NEWHOSTDIALOG_H_
#define __NEWHOSTDIALOG_H_

#include "../../config.h"
#include <newhostdialog_q.h>

#include "InterfaceData.h"

#include <map>

namespace libfwbuilder {
    class FWObject;
    class Host;
    class Interface;
    class Logger;
    class SNMP_interface_query;
};

class QListViewItem;
class QListBoxItem;
class QTimer;
class QTextEdit;

class newHostDialog : public newHostDialog_q
{
    Q_OBJECT

    libfwbuilder::Host                 *nhst;
    bool                                snmpPollCompleted;
    libfwbuilder::Logger               *logger;
    libfwbuilder::SNMP_interface_query *q;
    QTimer                             *timer;
    std::map<QListBoxItem*, libfwbuilder::FWObject*> templates;


    void fillInterfaceData(libfwbuilder::Interface *intf, QTextBrowser *qte);

 public:
    newHostDialog();
    virtual ~newHostDialog();

    libfwbuilder::Host* getNewHost() { return nhst; };

    virtual bool appropriate(QWidget *page) const;

public slots:
    virtual void addInterface();
    virtual void updateInterface();
    virtual void deleteInterface();
    virtual void changed();
    virtual void selectedInterface(QListViewItem *itm);
    virtual void getInterfacesViaSNMP();    
    virtual void monitor();
    virtual void templateSelected(QListBoxItem *itm);
    
 protected slots:
    void selected(const QString &title);
    virtual void accept();
 
};

#endif // __NEWHOSTDIALOG_H
