/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: upgradePredicate.h,v 1.2 2004/06/15 04:09:22 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __UPGRADEPREDICATE_H_
#define __UPGRADEPREDICATE_H_

#include "fwbuilder/XMLTools.h"

#include "qmessagebox.h"
#include "qobject.h"

class MessageBoxUpgradePredicate: public libfwbuilder::XMLTools::UpgradePredicate
{
    QWidget *parent;
 public:
    MessageBoxUpgradePredicate(QWidget *p=NULL) { parent=p; }
    
    virtual bool operator()(const std::string &msg) const 
    { 
        return QMessageBox::information( parent , "Firewall Builder", msg.c_str(),
                                         QObject::tr("&Upgrade"),
                                         QObject::tr("&Do not load the file"),
                                         QString::null,
                                         0, 1 )==0;
    }
};


#endif
