/* Copyright (C) 2000-2004 Damir Zucic */

/*=============================================================================

				write_hints.c

Purpose:
	Write some hints to the hidden pixmap.

Input:
	(1) Pointer to GUIS structure, with GUI data.

Output:
	(1) Some hints (textual information) written to hidden pixmap.
	(2) Return value.

Return value:
	(1) Positive always (trivial).

========includes:============================================================*/

#include <stdio.h>

#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include "defines.h"
#include "typedefs.h"

/*======write some hints to the hidden pixmap:===============================*/

int WriteHints_ (GUIS *guiSP)
{
int		screen_x, screen_y, delta_y;
char		stringA[STRINGSIZE];

/* Prepare the text color (green): */
XSetForeground (guiSP->displaySP, guiSP->theGCA[0], guiSP->green_colorID);

/* Draw hints: */
delta_y = guiSP->input_winS.text_line_height;
screen_x = 10;

screen_y = 60 + 2 * delta_y;
strcpy (stringA,
	"Home page (HTML documentation and GNU GPL license is there):");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_x = 40;

screen_y += delta_y;
strcpy (stringA, "http://garlic.mefos.hr/garlic-1.4");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_x = 10;

screen_y += 2 * delta_y;
strcpy (stringA, "Author: http://garlic.mefos.hr/zucic");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += 2 * delta_y;
strcpy (stringA, "Garlic development is supported as Project #0219031 by");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_x = 40;

screen_y += delta_y;
strcpy (stringA,
	"The Ministry of Science and Technology, Republic of Croatia");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

/* Change the text color (yellow): */
XSetForeground (guiSP->displaySP, guiSP->theGCA[0], guiSP->yellow_colorID);

screen_x = 10;

screen_y += 2 * delta_y;
strcpy (stringA, "Journal reference:");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_x = 40;

screen_y += delta_y;
strcpy (stringA, "Damir Zucic and Davor Juretic,");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += delta_y;
strcpy (stringA, "Precise Annotation of Transmembrane Segments");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += delta_y;
strcpy (stringA, "with Garlic - a Free Molecular Visualization Program,");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += delta_y;
strcpy (stringA, "Croatica Chemica Acta Vol. 77, No. 1-2, pp. 397-401 (2004).");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += delta_y;
strcpy (stringA, "Free PDF is available:");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

screen_y += delta_y;
strcpy (stringA, "http://public.carnet.hr/ccacaa/CCA-PDF/cca2004/v77-n1_n2/CCA_77_2004_397-401_zucic.pdf");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

/* Restore the text color (green): */
XSetForeground (guiSP->displaySP, guiSP->theGCA[0], guiSP->green_colorID);

screen_x = 10;

screen_y += 2 * delta_y;
strcpy (stringA, "Encourage garlic development - type reg to register!");
XDrawString (guiSP->displaySP, guiSP->main_hidden_pixmapID, guiSP->theGCA[0],
	     screen_x, screen_y, stringA, strlen (stringA));

/* Return positive value (trivial): */
return 1;
}

/*===========================================================================*/


