/* ANSI-C code produced by gperf version 2.7 */
/* Command-line: gperf -k 1-5,$ -t -L ANSI-C -l -C -c -N keywords_lookup keywords.gperf  */
/*
 * Gnome Basic keywords.
 *
 * Author:
 *     Jody Goldberg(jgoldberg@home.com)
 */
#include <glib.h>
#include "gb-statement.h"
#include "gb-expr.h"
#include "grammar.h"
#include <string.h>
#include <ctype.h>
struct GBKeyword { char const * const name; int const id; };

#define TOTAL_KEYWORDS 103
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 13
#define MIN_HASH_VALUE 3
#define MAX_HASH_VALUE 456
/* maximum key range = 454, duplicates = 0 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 120,  45,   2,  12,  75,
       45,  80, 457,  20, 457,  10,   0,   0,  95,  28,
      125, 457, 110,  84,  70,  10,   0,   5,   0, 457,
      457, 457, 457, 457, 457, 457, 457,   0,   5,  40,
       35,   0,  35,   0,   0,   0, 457,  25,  10,   0,
       15, 124,   0,   5,   0,  10,   0,   0,   5,  10,
       55, 105, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457, 457, 457, 457, 457,
      457, 457, 457, 457, 457, 457
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 5:
        hval += asso_values[(unsigned char)str[4]];
      case 4:
        hval += asso_values[(unsigned char)str[3]];
      case 3:
        hval += asso_values[(unsigned char)str[2]];
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval + asso_values[(unsigned char)str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
const struct GBKeyword *
keywords_lookup (register const char *str, register unsigned int len)
{
  static const unsigned char lengthtable[] =
    {
       0,  0,  0,  3,  0,  0,  0,  0,  0,  4,  5,  0,  0,  3,
       4,  3,  4,  0,  0,  4,  5,  0,  0,  3,  0,  8,  0,  0,
       0,  4,  2,  0,  7,  3,  6, 13,  4,  0,  0,  0,  5,  0,
       2,  0,  4,  0,  0,  5,  0,  0,  5,  0,  2,  0,  0,  0,
       0,  0,  0,  4,  2,  0,  4,  0,  0,  0,  0,  0,  0,  7,
       5,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  3,
       0,  0,  0,  3,  4,  0,  5,  7,  2,  3,  4,  0,  0,  3,
       0,  4,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0, 11,  0,
       0,  3,  0,  0,  0,  0,  3,  4,  0,  0,  0,  8,  4,  5,
       6,  3,  3,  9,  6,  6,  0,  7,  4,  0,  6,  7,  4,  5,
       6,  0,  2,  8,  0,  5,  0,  0,  8,  0,  5,  5,  0,  0,
       4,  5,  5,  0,  0,  7,  0,  0,  0,  3,  0,  0,  0,  0,
       0,  0,  8,  6,  3,  6,  0,  6,  6,  8,  0,  4,  5,  0,
       0,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  3,  4,  0,  6,  0,  0,  0,  5,  0,  0,  0,  3,  0,
       0,  0,  4,  0,  0,  0,  0,  0,  4,  0,  0,  0,  3,  0,
       0,  5,  7,  0,  0,  5,  6,  0,  0,  0,  0,  6,  0,  0,
       0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6,  0,  0,  9,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  8,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  4
    };
  static const struct GBKeyword wordlist[] =
    {
      {""}, {""}, {""},
      {"Let",		GB_LET},
      {""}, {""}, {""}, {""}, {""},
      {"With",		GB_WITH},
      {"Write",		GB_WRITE},
      {""}, {""},
      {"Lib",		GB_LIB},
      {"Lset",		GB_LSET},
      {"Dim",		GB_DIM},
      {"Case",		GB_CASE},
      {""}, {""},
      {"Line",		GB_LINE},
      {"While",		GB_WHILE},
      {""}, {""},
      {"Imp",		GB_IMP},
      {""},
      {"Database",	GB_DATABASE},
      {""}, {""}, {""},
      {"Like",		GB_LIKE},
      {"Or",		GB_OR},
      {""},
      {"Version", 	GB_VERSION},
      {"Len",            GB_LEN},
      {"Output",		GB_OUTPUT},
      {"Deletesetting",	GB_DELETESETTING},
      {"Call",		GB_CALL},
      {""}, {""}, {""},
      {"Input",		GB_INPUT},
      {""},
      {"Is",		GB_IS},
      {""},
      {"Kill",		GB_KILL},
      {""}, {""},
      {"Class",          GB_CLASS},
      {""}, {""},
      {"Until",		GB_UNTIL},
      {""},
      {"In",		GB_IN},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Base",		GB_BASE},
      {"On",		GB_ON},
      {""},
      {"Open",		GB_OPEN},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Declare",	GB_DECLARE},
      {"False",		GB_FALSE},
      {""}, {""}, {""},
      {"True",		GB_TRUE},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Get",		GB_GET},
      {""}, {""}, {""},
      {"Set",		GB_SET},
      {"Step",		GB_STEP},
      {""},
      {"Erase",		GB_ERASE},
      {"Setattr",	GB_SETATTR},
      {"If",		GB_IF},
      {"Eqv",		GB_EQV},
      {"Wend",		GB_WEND},
      {""}, {""},
      {"Sub",		GB_SUB},
      {""},
      {"Else",		GB_ELSE},
      {""}, {""}, {""}, {""},
      {"Then",		GB_THEN},
      {""}, {""}, {""}, {""}, {""},
      {"Savesetting",	GB_SAVESETTING},
      {""}, {""},
      {"Rem",		GB_REM},
      {""}, {""}, {""}, {""},
      {"New",            GB_NEW},
      {"Each",		GB_EACH},
      {""}, {""}, {""},
      {"Function",	GB_FUNCTION},
      {"Rset",		GB_RSET},
      {"Reset",		GB_RESET},
      {"Resume",		GB_RESUME},
      {"Xor",		GB_XOR},
      {"Put",		GB_PUT},
      {"Attribute",	GB_ATTRIBUTE},
      {"Static",		GB_STATIC},
      {"Return",		GB_RETURN},
      {""},
      {"Compare",	GB_COMPARE},
      {"Exit",		GB_EXIT},
      {""},
      {"Elseif",		GB_ELSE_IF},
      {"Private",	GB_PRIVATE},
      {"Seek",		GB_SEEK},
      {"Scale",	 	GB_SCALE},
      {"Select",		GB_SELECT},
      {""},
      {"As",		GB_AS},
      {"Preserve",	GB_PRESERVE},
      {""},
      {"Print",	        GB_PRINT},
      {""}, {""},
      {"Explicit",	GB_EXPLICIT},
      {""},
      {"Redim",		GB_REDIM},
      {"Close",		GB_CLOSE},
      {""}, {""},
      {"Next",		GB_NEXT},
      {"Alias",		GB_ALIAS},
      {"Const",		GB_CONST},
      {""}, {""},
      {"Deftype",	GB_DEFTYPE},
      {""}, {""}, {""},
      {"End",		GB_END},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Optional",	GB_OPTIONAL},
      {"Binary",		GB_BINARY},
      {"For",		GB_FOR},
      {"Option",		GB_OPTION},
      {""},
      {"Module",		GB_MODULE},
      {"Append",		GB_APPEND},
      {"Sendkeys",	GB_SENDKEYS},
      {""},
      {"Type",           GB_TYPE},
      {"Byval",		GB_BYVAL},
      {""}, {""}, {""}, {""}, {""},
      {"Public",		GB_PUBLIC},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"Mod",		GB_MOD},
      {"Load",		GB_LOAD},
      {""},
      {"Unload",		GB_UNLOAD},
      {""}, {""}, {""},
      {"Error",		GB_ERROR},
      {""}, {""}, {""},
      {"And",		GB_AND},
      {""}, {""}, {""},
      {"Stop",		GB_STOP},
      {""}, {""}, {""}, {""}, {""},
      {"Lock",		GB_LOCK},
      {""}, {""}, {""},
      {"Not",		GB_NOT},
      {""}, {""},
      {"Byref",		GB_BYREF},
      {"Nothing",	GB_NOTHING},
      {""}, {""},
      {"Gosub",		GB_GOSUB},
      {"Unlock",		GB_UNLOCK},
      {""}, {""}, {""}, {""},
      {"Global",		GB_GLOBAL},
      {""}, {""}, {""}, {""},
      {"Paramarray",	GB_PARAM_ARRAY},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"Loop",		GB_LOOP},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Do",		GB_DO},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Random",         GB_RANDOM},
      {""}, {""},
      {"Randomize",	GB_RANDOMIZE},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"To",		GB_TO},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"Property",	GB_PROPERTY},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"Goto",		GB_GOTO}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        if (len == lengthtable[key])
          {
            register const char *s = wordlist[key].name;

            if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
              return &wordlist[key];
          }
    }
  return 0;
}
char *
correct_case (char const *str)
{
	char *tmp = g_strdup (str);

	g_strdown (tmp);
	tmp[0] = (char) toupper ((int) tmp[0]);

	return tmp;
}

int
gb_is_keyword (char const *str, unsigned const len)
{
	char                   *str_case;
	const struct GBKeyword *keyword;

	str_case = correct_case (str);
	keyword  = keywords_lookup (str_case, len);
	g_free (str_case);

	if (keyword == NULL)
		return 0;
#if 0
	printf ("Keyword : %s\n", keyword->name);
#endif

	return keyword->id;
}
