/*
** Copyright (C) 16 Mar 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <stdlib.h>

#include "common_gtk.h"
#include "detect_scsi.h"
#include "mainwindow.h"
#include "globals.h"

/* This is an internally used function to set notebook tab widgets.
 *  - added by glade
 */

void set_notebook_tab(GtkWidget *notebook, gint page_num, GtkWidget *widget) {
	  GtkNotebookPage *page;
	  GtkWidget *notebook_page;

	  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children,
			  page_num)->data;
	  notebook_page = page->child;
	  gtk_widget_ref (notebook_page);
	  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
	  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
				widget, page_num);
	  gtk_widget_unref (notebook_page);
}

void choose_path(GtkWidget *widget, gpointer add_struct) {
	GtkWidget *selector;
	file_req_info *add_info = add_struct;

	selector = gtk_file_selection_new(add_info->title);
	gtk_signal_connect_object(GTK_OBJECT(selector), "destroy",
			(GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(selector));

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(selector)->ok_button),
			"clicked",
			GTK_SIGNAL_FUNC(add_info->func), GTK_OBJECT(selector));
	gtk_signal_connect_object(
			GTK_OBJECT(GTK_FILE_SELECTION(selector)->cancel_button),
			"clicked",
			(GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(selector));
	gtk_widget_show(selector);
}

void close_dialog(GtkWidget *widget, gpointer data) {
	gtk_widget_destroy(data);
}

static GtkWidget *new_base_error_dialog(char *error_msg) {
	GtkWidget *dialog, *label, *button;

	dialog = gtk_dialog_new();
	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(close_dialog), (gpointer) dialog);
	label = gtk_label_new(error_msg);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label,
			TRUE, TRUE, 15);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button,
			TRUE, TRUE, 15);

	return dialog;
}

/* Informs the user of that an error occured and let's him aknowledge it. */
void alert_user_of_error(gchar *error_msg) {
	g_warning("alert_user_of_error: %s\n", error_msg);
	gtk_widget_show_all(new_base_error_dialog(error_msg));
}

void alert_user_of_error_with_cb(gchar *error_msg, GtkSignalFunc callback) {
	GtkWidget *dialog;

	g_warning("alert_user_of_error_with_cb: %s\n", error_msg);
	dialog = new_base_error_dialog(error_msg);
	gtk_signal_connect(GTK_OBJECT(dialog), "destroy",
			GTK_SIGNAL_FUNC(callback), (gpointer) dialog);
	gtk_widget_show_all(dialog);
}

void alert_user_of_error_msg(gchar *error_msg, gchar *verbose_msg) {
	GtkWidget *dialog;
	GtkWidget *text, *vscrollbar, *hbox;

	g_warning("alert_user_of_error_msg: %s\n", error_msg);
	g_warning("alert_user_of_error_msg: %s\n", verbose_msg);
	dialog = new_base_error_dialog(error_msg);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox,
			TRUE, TRUE, 15);

	text = gtk_text_new(NULL, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), text, TRUE, TRUE, 0);
	vscrollbar = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
	gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);

	gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, verbose_msg, -1);

	gtk_widget_show_all(dialog);
}

GtkWidget *make_frame(gchar *title, gint w) {
	GtkWidget *frame;

	frame = gtk_frame_new(title);
	gtk_container_border_width(GTK_CONTAINER(frame), w);
	gtk_widget_show(frame);
	return frame;
}

config_cdr_data *config_cdr(int config_flags) {
	GtkWidget *table, *lun, *target, *scsibus, *frame, *hbox, *vbox2;
	GtkWidget *check_drive, *auto_detect_drive, *reset_drive, *vbox, *vbox3;
	GtkWidget *spinbutton_lun, *spinbutton_target, *spinbutton_scsibus;
	GtkWidget *driver_entry, *driver_label, *dev_entry, *dev_label, *advanced_frame;
	GtkObject *spinbutton_scsibus_adj, *spinbutton_target_adj, *spinbutton_lun_adj;
	config_cdr_data *info;

	info = malloc(sizeof(config_cdr_data));

	frame = make_frame(_("CD-Recorder device options"), 5);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(vbox), hbox);

	table = gtk_table_new(3, 2, FALSE);
	gtk_widget_show(table);
	gtk_container_add(GTK_CONTAINER(hbox), table);

	lun = gtk_label_new(_("Lun:"));
	gtk_widget_show(lun);
	gtk_table_attach(GTK_TABLE(table), lun, 0, 1, 2, 3,
			GTK_SHRINK, GTK_SHRINK, 0, 0);
	gtk_label_set_justify(GTK_LABEL(lun), GTK_JUSTIFY_LEFT);

	target = gtk_label_new(_("Target:"));
	gtk_widget_show(target);
	gtk_table_attach(GTK_TABLE(table), target, 0, 1, 1, 2,
			GTK_SHRINK, GTK_SHRINK, 0, 0);
	gtk_label_set_justify(GTK_LABEL(target), GTK_JUSTIFY_LEFT);

	scsibus = gtk_label_new(_("SCSI-bus:"));
	gtk_widget_show(scsibus);
	gtk_table_attach(GTK_TABLE(table), scsibus, 0, 1, 0, 1,
			GTK_SHRINK, GTK_SHRINK, 0, 0);
	gtk_label_set_justify(GTK_LABEL(scsibus), GTK_JUSTIFY_LEFT);

	spinbutton_lun_adj = gtk_adjustment_new(0, 0, 100, 1, 10, 10);
	spinbutton_lun = gtk_spin_button_new(GTK_ADJUSTMENT(spinbutton_lun_adj), 1, 0);
	gtk_widget_show(spinbutton_lun);
	gtk_table_attach(GTK_TABLE(table), spinbutton_lun, 1, 2, 2, 3,
			GTK_SHRINK, GTK_SHRINK, 0, 0);
#ifdef __FreeBSD__
	gtk_tooltips_set_tip(tooltips, spinbutton_lun,
			_("See /sbin/dmesg and man cdrecord"), NULL);
#else
	gtk_tooltips_set_tip(tooltips, spinbutton_lun,
			_("See /proc/scsi/scsi and man cdrecord"), NULL);
#endif

	spinbutton_target_adj = gtk_adjustment_new(0, 0, 100, 1, 10, 10);
	spinbutton_target = gtk_spin_button_new(GTK_ADJUSTMENT(spinbutton_target_adj), 1, 0);
	gtk_widget_show(spinbutton_target);
	gtk_table_attach(GTK_TABLE(table), spinbutton_target, 1, 2, 1, 2,
			GTK_SHRINK, GTK_SHRINK, 0, 0);
#ifdef __FreeBSD__
	gtk_tooltips_set_tip(tooltips, spinbutton_target,
			_("See /sbin/dmesg and man cdrecord"), NULL);
#else
	gtk_tooltips_set_tip(tooltips, spinbutton_target,
			_("See /proc/scsi/scsi and man cdrecord"), NULL);
#endif

	spinbutton_scsibus_adj = gtk_adjustment_new(0, 0, 100, 1, 10, 10);
	spinbutton_scsibus = gtk_spin_button_new(GTK_ADJUSTMENT(spinbutton_scsibus_adj), 1, 0);
	gtk_widget_show(spinbutton_scsibus);
	gtk_table_attach(GTK_TABLE(table), spinbutton_scsibus, 1, 2, 0, 1,
			GTK_SHRINK, GTK_SHRINK, 0, 0);
#ifdef __FreeBSD__
	gtk_tooltips_set_tip(tooltips, spinbutton_scsibus,
			_("See /sbin/dmesg and man cdrecord"), NULL);
#else
	gtk_tooltips_set_tip(tooltips, spinbutton_scsibus,
			_("See /proc/scsi/scsi and man cdrecord"), NULL);
#endif

	gtk_adjustment_set_value(GTK_ADJUSTMENT(spinbutton_target_adj), 6);

	advanced_frame = make_frame(_("Advanced: override cdrecord defaults"), 2);

	vbox3 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox3);
	gtk_container_add(GTK_CONTAINER(advanced_frame), vbox3);
	gtk_box_pack_start(GTK_BOX(vbox), advanced_frame, TRUE, FALSE, 0);

	vbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_container_add(GTK_CONTAINER(vbox3), vbox2);

	dev_label = gtk_label_new(_("Device:"));
	gtk_widget_show(dev_label);
	gtk_box_pack_start(GTK_BOX(vbox2), dev_label, TRUE, TRUE, 0);

	dev_entry = gtk_entry_new();
	gtk_widget_show(dev_entry);
	gtk_box_pack_start(GTK_BOX(vbox2), dev_entry, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, dev_entry,
			_("SCSI target for the CD recorder. If this is non-empty it is "
				"used instead of the SCSI-bus/target/lun above. "
				"(example: /dev/sga)"), NULL);

	driver_label = gtk_label_new(_("Driver:"));
	gtk_widget_show(driver_label);
	gtk_box_pack_start(GTK_BOX(vbox2), driver_label, TRUE, TRUE, 0);

	driver_entry = gtk_entry_new();
	gtk_widget_show(driver_entry);
	gtk_box_pack_start(GTK_BOX(vbox2), driver_entry, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, driver_entry,
			_("Tell cdrecord to use a specific driver. This should "
				"usually be left empty unless you know what you are "
				"doing (try man cdrecord and cdrecord driver=help)."), NULL);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_box_pack_start(GTK_BOX(hbox), vbox2, TRUE, FALSE, 0);

	check_drive = gtk_button_new_with_label(_("Check SCSI settings"));
	gtk_widget_show(check_drive);
	gtk_box_pack_start(GTK_BOX(vbox2), check_drive, TRUE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, check_drive,
			_("Checks if a driver for the selected drive is present"), NULL);
	gtk_signal_connect(GTK_OBJECT(check_drive),
			"clicked", (GtkSignalFunc) cdrecord_checkdrive, info);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_box_pack_start(GTK_BOX(hbox), vbox2, TRUE, FALSE, 0);

	auto_detect_drive = gtk_button_new_with_label(_("Detect SCSI drive"));
	gtk_widget_show(auto_detect_drive);
	gtk_box_pack_start(GTK_BOX(vbox2), auto_detect_drive, TRUE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, auto_detect_drive, _("Automatically locates "
				"your drive, press multiple times to cycle through "
				"SCSI devices if you have more than one"), NULL);
	gtk_signal_connect(GTK_OBJECT(auto_detect_drive),
			"clicked", (GtkSignalFunc) cdrecord_auto_detect_drive, info);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_box_pack_start(GTK_BOX(hbox), vbox2, TRUE, FALSE, 0);

	if (config_flags & RESET_BUTTON) {
		reset_drive = gtk_button_new_with_label(_("Reset drive"));
		gtk_widget_show(reset_drive);
		gtk_box_pack_start(GTK_BOX(vbox2), reset_drive, TRUE, FALSE, 0);
		gtk_tooltips_set_tip(tooltips, reset_drive, _("Try to reset the "
					"SCSI bus where the CD recorder is located"), NULL);
		gtk_signal_connect(GTK_OBJECT(reset_drive),
				"clicked", (GtkSignalFunc) cdrecord_reset_drive, info);
	}

	info->widget = frame;
	info->hbox = vbox;
	info->scsibus = spinbutton_scsibus;
	info->target = spinbutton_target;
	info->lun = spinbutton_lun;
	info->driver = driver_entry;
	info->device = dev_entry;

	return info;
}

void cursor_wait(void) {
	GdkCursor *cursor;

	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor (mainwindow->window, cursor);
	gdk_flush();
	gdk_cursor_destroy(cursor);
}

void cursor_reset(void) {
  gdk_window_set_cursor(mainwindow->window, NULL);
}

