/******************************************************************************
**
** parse_cl.cc
**
** Wed Oct 25 16:53:10 2000
** Linux 2.2.17 (#1 Mon Oct 23 14:35:56 CDT 2000) i686
** mborella@mb.mw.3com.com. (Mike Borella)
**
** Definition of command line parser class
**
** Automatically created by genparse v0.5.2
**
** See http://genparse.sourceforge.net/ for details and updates
**
******************************************************************************/

#include <getopt.h>
#include <stdlib.h>
#include "parse_cl.h"

/*----------------------------------------------------------------------------
**
** Cmdline::Cmdline()
**
** Constructor method.
**
**--------------------------------------------------------------------------*/

Cmdline::Cmdline(int argc, char *argv[]) throw (string)
{
  extern char *optarg;
  extern int optind;
  int option_index = 0;
  int c;

  static struct option long_options[] =
  {
    {"cppext", 1, 0, 'c'},
    {"", 0, 0, 'd'},
    {"logfile", 1, 0, 'f'},
    {"language", 1, 0, 'l'},
    {"outfile", 1, 0, 'o'},
    {"parsefunc", 1, 0, 'p'},
    {"quiet", 0, 0, 'q'},
    {"help", 0, 0, 'h'},
    {"version", 0, 0, 'v'},
    {0, 0, 0, 0}
  };

  _executable += argv[0];

  /* default values */
  _c = "cc";
  _d = false;
  _f = "genparse.log";
  _l = "c";
  _o = "parse_cl";
  _p = "Cmdline";
  _q = false;
  _h = false;
  _v = false;

  while ((c = getopt_long(argc, argv, "c:df:l:o:p:qhv", long_options, &option_index)) != EOF)
    {
      switch(c)
        {
        case 'c': 
          _c = optarg;
          break;

        case 'd': 
          _d = true;
          break;

        case 'f': 
          _f = optarg;
          break;

        case 'l': 
          _l = optarg;
          break;

        case 'o': 
          _o = optarg;
          break;

        case 'p': 
          _p = optarg;
          break;

        case 'q': 
          _q = true;
          break;

        case 'h': 
          _h = true;
          this->usage();
          break;

        case 'v': 
          _v = true;
          break;

        default:
          this->usage();

        }
    } /* while */

  _optind = optind;
}

/*----------------------------------------------------------------------------
**
** Cmdline::usage()
**
** Usage function.
**
**--------------------------------------------------------------------------*/

void Cmdline::usage()
{
  cout << "usage: " << _executable << " [ -cdflopqhv ]  <file>" << endl;
  cout << "  [ -c ] ";
  cout << "[ --cppext ]  ";
  cout << "(";
  cout << "type=";
  cout << "STRING,";
  cout << " default=cc";
  cout << ")\n";
  cout << "         C++ file extension.\n";
  cout << "  [ -d ] ";
  cout << "(";
  cout << "type=";
  cout << "FLAG";
  cout << ")\n";
  cout << "         Turns on logging.\n";
  cout << "  [ -f ] ";
  cout << "[ --logfile ]  ";
  cout << "(";
  cout << "type=";
  cout << "STRING,";
  cout << " default=genparse.log";
  cout << ")\n";
  cout << "         Log file name.\n";
  cout << "  [ -l ] ";
  cout << "[ --language ]  ";
  cout << "(";
  cout << "type=";
  cout << "STRING,";
  cout << " default=c";
  cout << ")\n";
  cout << "         Output language.\n";
  cout << "  [ -o ] ";
  cout << "[ --outfile ]  ";
  cout << "(";
  cout << "type=";
  cout << "STRING,";
  cout << " default=parse_cl";
  cout << ")\n";
  cout << "         Output file name.\n";
  cout << "  [ -p ] ";
  cout << "[ --parsefunc ]  ";
  cout << "(";
  cout << "type=";
  cout << "STRING,";
  cout << " default=Cmdline";
  cout << ")\n";
  cout << "         Name of parsing function / class.\n";
  cout << "  [ -q ] ";
  cout << "[ --quiet ]  ";
  cout << "(";
  cout << "type=";
  cout << "FLAG";
  cout << ")\n";
  cout << "         Turns on quiet mode.\n";
  cout << "  [ -h ] ";
  cout << "[ --help ]  ";
  cout << "(";
  cout << "type=";
  cout << "FLAG";
  cout << ")\n";
  cout << "         Display help information.\n";
  cout << "  [ -v ] ";
  cout << "[ --version ]  ";
  cout << "(";
  cout << "type=";
  cout << "FLAG";
  cout << ")\n";
  cout << "         Output version.\n";
  exit(0);
}

