/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  unicode.cc - gunichar C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "unicode.hh"

using namespace GFC;

G::Unichar::Unichar()
: Base(0)
{
}

G::Unichar::Unichar(gunichar c)
: Base(c)
{
}

G::Unichar::Unichar(const Unichar& src) 
: Base(src.value_)
{
}

G::Unichar&
G::Unichar::operator=(const Unichar& src)
{ 
	value_ = src.value_;
	return *this;
}

bool
G::Unichar::get_mirror_char(Unichar *mirrored_ch)
{
	gunichar tmp_mirrored_ch;
	bool result = g_unichar_get_mirror_char(value_, &tmp_mirrored_ch);
	if (mirrored_ch)
		*mirrored_ch = tmp_mirrored_ch;
	return result;
}

