/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  iconsource.inl - Gtk::IconSource inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkIconSource*
GFC::Gtk::IconSource::gtk_icon_source() const
{
	return reinterpret_cast<GtkIconSource*>(boxed_);
}

inline GFC::Gtk::IconSource::operator GtkIconSource* () const
{
	return this ? gtk_icon_source() : 0;
}

inline bool
GFC::Gtk::IconSource::get_size_wildcarded() const
{
	return gtk_icon_source_get_size_wildcarded(gtk_icon_source());
}

inline bool
GFC::Gtk::IconSource::get_state_wildcarded() const
{
	return gtk_icon_source_get_state_wildcarded(gtk_icon_source());
}

inline bool
GFC::Gtk::IconSource::get_direction_wildcarded() const
{
	return gtk_icon_source_get_direction_wildcarded(gtk_icon_source());
}

inline GFC::Gtk::TextDirection
GFC::Gtk::IconSource::get_direction() const
{
	return (TextDirection)gtk_icon_source_get_direction(gtk_icon_source());
}

inline GFC::Gtk::StateType
GFC::Gtk::IconSource::get_state() const
{
	return (StateType)gtk_icon_source_get_state(gtk_icon_source());
}

inline GFC::Gtk::IconSize
GFC::Gtk::IconSource::get_size() const
{
	return (IconSize)gtk_icon_source_get_size(gtk_icon_source());
}

inline void
GFC::Gtk::IconSource::set_filename(const char *filename)
{
	gtk_icon_source_set_filename(gtk_icon_source(), filename);
}

inline void
GFC::Gtk::IconSource::set_icon_name(const char *icon_name)
{
	gtk_icon_source_set_icon_name(gtk_icon_source(), icon_name);
}

inline void
GFC::Gtk::IconSource::set_direction_wildcarded(bool setting)
{
	gtk_icon_source_set_direction_wildcarded(gtk_icon_source(), setting);
}

inline void
GFC::Gtk::IconSource::set_state_wildcarded(bool setting)
{
	gtk_icon_source_set_state_wildcarded(gtk_icon_source(), setting);
}

inline void
GFC::Gtk::IconSource::set_size_wildcarded(bool setting)
{
	gtk_icon_source_set_size_wildcarded(gtk_icon_source(), setting);
}

inline void
GFC::Gtk::IconSource::set_direction(TextDirection direction)
{
	gtk_icon_source_set_direction(gtk_icon_source(), (GtkTextDirection)direction);
}

inline void
GFC::Gtk::IconSource::set_state(StateType state)
{
	gtk_icon_source_set_state(gtk_icon_source(), (GtkStateType)state);
}

inline void
GFC::Gtk::IconSource::set_size(IconSize size)
{
	gtk_icon_source_set_size(gtk_icon_source(), (GtkIconSize)size);
}

