/*  GFC-UI: Gtk+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  gfcui.cc - Main GFC-UI source file
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gfcui.hh"

/*  GFC-UI major, minor and micro version numbers
 */

extern const unsigned int gfc_ui_major_version = GFC_UI_MAJOR_VERSION;
extern const unsigned int gfc_ui_minor_version = GFC_UI_MINOR_VERSION;
extern const unsigned int gfc_ui_micro_version = GFC_UI_MICRO_VERSION;

/*  gfc_ui_check_version
 */

bool gfc_ui_check_version(int major, int minor, int micro)
{
	return (GFC_UI_MAJOR_VERSION > major ||
	       (GFC_UI_MAJOR_VERSION == major && GFC_UI_MINOR_VERSION > minor) ||
	       (GFC_UI_MAJOR_VERSION == major && GFC_UI_MINOR_VERSION == minor && GFC_UI_MICRO_VERSION >= micro));
}

