/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  toggletoolbutton.cc - GtkToggleToolButton C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "toggletoolbutton.hh"
#include "private/toggletoolbuttonclass.hh"
#include "private/marshal.hh"
#include "stockid.hh"

using namespace GFC;

/*  Gtk::ToggleToolButton
 */

Gtk::ToggleToolButton::ToggleToolButton(GtkToggleToolButton *button, bool owns_reference)
: ToolButton((GtkToolButton*)button, owns_reference)
{
}

Gtk::ToggleToolButton::ToggleToolButton()
: ToolButton((GtkToolButton*)ToggleToolButtonClass::create())
{
}	

Gtk::ToggleToolButton::ToggleToolButton(const StockId& stock_id)
: ToolButton((GtkToolButton*)ToggleToolButtonClass::create())
{
	set_stock_id(stock_id);
}

Gtk::ToggleToolButton::~ToggleToolButton()
{
}

/*  Gtk::ToggleToolButton signals
 */

const Gtk::ToggleToolButton::ToggledSignalType Gtk::ToggleToolButton::toggled_signal("toggled", (GCallback)&G::Marshal::void_callback);

