/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  widget.cc - GtkWidget C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "widget.hh"
#include "widgetsignals.hh"
#include "style.hh"
#include "private/widgetclass.hh"
#include "../gdk/screen.hh"

using namespace GFC;

/*  Gtk::WidgetSignals
 */

Gtk::WidgetSignals::WidgetSignals(Widget *widget)
: ObjectSignals(widget)
{
	Gtk::WidgetClass::init(GTK_WIDGET_GET_CLASS(widget->gtk_widget()));
}

Gtk::WidgetSignals::~WidgetSignals()
{
}

void
Gtk::WidgetSignals::on_show()
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->show)
		g_class->show((GtkWidget*)instance_);
}

void
Gtk::WidgetSignals::on_hide()
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->hide)
		g_class->hide((GtkWidget*)instance_);
}

void
Gtk::WidgetSignals::on_map()
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->map)
		g_class->map((GtkWidget*)instance_);
}

void
Gtk::WidgetSignals::on_unmap()
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->unmap)
		g_class->unmap((GtkWidget*)instance_);
}

void
Gtk::WidgetSignals::on_realize()
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->realize)
		g_class->realize((GtkWidget*)instance_);
}

void
Gtk::WidgetSignals::on_unrealize()
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->unrealize)
		g_class->unrealize((GtkWidget*)instance_);
}

void
Gtk::WidgetSignals::on_size_request(Requisition *requisition)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->size_request)
		g_class->size_request((GtkWidget*)instance_, requisition->gtk_requisition());
}

void
Gtk::WidgetSignals::on_size_allocate(const Allocation& allocation)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->size_allocate)
		g_class->size_allocate((GtkWidget*)instance_, allocation.gtk_allocation());
}

void
Gtk::WidgetSignals::on_state_changed(StateType previous_state)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->state_changed)
		g_class->state_changed((GtkWidget*)instance_, (GtkStateType)previous_state);
}

void
Gtk::WidgetSignals::on_parent_set(Widget *previous_parent)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->parent_set)
		g_class->parent_set((GtkWidget*)instance_, *previous_parent);
}

void
Gtk::WidgetSignals::on_hierarchy_changed(Widget *previous_toplevel)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->hierarchy_changed)
		g_class->hierarchy_changed((GtkWidget*)instance_, *previous_toplevel);
}

void
Gtk::WidgetSignals::on_style_set(Style* previous_style)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->style_set)
		g_class->style_set((GtkWidget*)instance_, *previous_style);
}

void
Gtk::WidgetSignals::on_direction_changed(TextDirection  previous_direction)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->direction_changed)
		g_class->direction_changed((GtkWidget*)instance_, (GtkTextDirection)previous_direction);
}

void
Gtk::WidgetSignals::on_grab_notify(bool was_grabbed)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->grab_notify)
		g_class->grab_notify((GtkWidget*)instance_, was_grabbed);
}

void
Gtk::WidgetSignals::on_child_notify(GParamSpec *pspec)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->child_notify)
		g_class->child_notify((GtkWidget*)instance_, pspec);
}

bool
Gtk::WidgetSignals::on_mnemonic_activate(bool group_cycling)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->mnemonic_activate)
		result = g_class->mnemonic_activate((GtkWidget*)instance_, group_cycling);
	return result;
}

void
Gtk::WidgetSignals::on_grab_focus()
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->grab_focus)
		g_class->grab_focus((GtkWidget*)instance_);
}

bool
Gtk::WidgetSignals::on_focus(DirectionType direction)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->focus)
		result = g_class->focus((GtkWidget*)instance_, (GtkDirectionType)direction);
	return result;
}

void
Gtk::WidgetSignals::on_screen_changed(Gdk::Screen *previous_screen)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->screen_changed)
		g_class->screen_changed((GtkWidget*)instance_, *previous_screen);
}

bool
Gtk::WidgetSignals::on_can_activate_accel(unsigned int signal_id)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->can_activate_accel)
		result = g_class->can_activate_accel((GtkWidget*)instance_, signal_id);
	return result;
}

void
Gtk::WidgetSignals::on_selection_get(SelectionData& selection_data, unsigned int info, unsigned int time)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->selection_get)
		g_class->selection_get((GtkWidget*)instance_, selection_data.gtk_selection_data(), info, time);
}

void
Gtk::WidgetSignals::on_selection_received(const SelectionData& selection_data, unsigned int time)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->selection_received)
		g_class->selection_received((GtkWidget*)instance_, selection_data.gtk_selection_data(), time);
}

void
Gtk::WidgetSignals::on_drag_begin(DragContext& context)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->drag_begin)
		g_class->drag_begin((GtkWidget*)instance_, context.gdk_drag_context());
}

void
Gtk::WidgetSignals::on_drag_end(DragContext& context)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->drag_end)
		g_class->drag_end((GtkWidget*)instance_, context.gdk_drag_context());
}

void
Gtk::WidgetSignals::on_drag_data_get(DragContext& context, SelectionData& selection_data, unsigned int info, unsigned int time)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->drag_data_get)
		g_class->drag_data_get((GtkWidget*)instance_, context.gdk_drag_context(), selection_data.gtk_selection_data(), info, time);
}

void
Gtk::WidgetSignals::on_drag_data_delete(DragContext& context)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->drag_data_delete)
		g_class->drag_data_delete((GtkWidget*)instance_, context.gdk_drag_context());
}

void
Gtk::WidgetSignals::on_drag_leave(DragContext& context, unsigned int time)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->drag_leave)
		g_class->drag_leave((GtkWidget*)instance_, context.gdk_drag_context(), time);
}

bool
Gtk::WidgetSignals::on_drag_motion(DragContext& context, int x, int y, unsigned int time)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->drag_motion)
		result = g_class->drag_motion((GtkWidget*)instance_, context.gdk_drag_context(), x, y, time);
	return result;
}

bool
Gtk::WidgetSignals::on_drag_drop(DragContext& context, int x, int y, unsigned int time)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->drag_drop)
		result = g_class->drag_drop((GtkWidget*)instance_, context.gdk_drag_context(), x, y, time);
	return result;
}

void
Gtk::WidgetSignals::on_drag_data_received(DragContext& context, int x, int y, const SelectionData& selection_data, unsigned int info, unsigned int time)
{
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->drag_data_received)
		g_class->drag_data_received((GtkWidget*)instance_, context.gdk_drag_context(), x, y, selection_data.gtk_selection_data(), info, time);
}

bool
Gtk::WidgetSignals::on_event(const Gdk::Event& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->event)
		result = g_class->event((GtkWidget*)instance_, event.gdk_event());
	return result;
}

bool
Gtk::WidgetSignals::on_button_press_event(const Gdk::EventButton& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->button_press_event)
		result = g_class->button_press_event((GtkWidget*)instance_, event.gdk_event_button());
	return result;
}

bool
Gtk::WidgetSignals::on_button_release_event(const Gdk::EventButton& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->button_release_event)
		result = g_class->button_release_event((GtkWidget*)instance_, event.gdk_event_button());
	return result;
}

bool
Gtk::WidgetSignals::on_scroll_event(const Gdk::EventScroll& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->scroll_event)
		result = g_class->scroll_event((GtkWidget*)instance_, event.gdk_event_scroll());
	return result;
}

bool
Gtk::WidgetSignals::on_motion_notify_event(const Gdk::EventMotion& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->motion_notify_event)
		result = g_class->motion_notify_event((GtkWidget*)instance_, event.gdk_event_motion());
	return result;
}

bool
Gtk::WidgetSignals::on_delete_event(const Gdk::EventAny& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->delete_event)
		result = g_class->delete_event((GtkWidget*)instance_, event.gdk_event_any());
	return result;
}

bool
Gtk::WidgetSignals::on_destroy_event(const Gdk::EventAny& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->destroy_event)
		result = g_class->destroy_event((GtkWidget*)instance_, event.gdk_event_any());
	return result;
}

bool
Gtk::WidgetSignals::on_expose_event(const Gdk::EventExpose& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->expose_event)
		result = g_class->expose_event((GtkWidget*)instance_, event.gdk_event_expose());
	return result;
}

bool
Gtk::WidgetSignals::on_key_press_event(const Gdk::EventKey& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->key_press_event)
		result = g_class->key_press_event((GtkWidget*)instance_, event.gdk_event_key());
	return result;
}

bool
Gtk::WidgetSignals::on_key_release_event(const Gdk::EventKey& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->key_release_event)
		result = g_class->key_release_event((GtkWidget*)instance_, event.gdk_event_key());
	return result;
}

bool
Gtk::WidgetSignals::on_enter_notify_event(const Gdk::EventCrossing& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->enter_notify_event)
		result = g_class->enter_notify_event((GtkWidget*)instance_, event.gdk_event_crossing());
	return result;
}

bool
Gtk::WidgetSignals::on_leave_notify_event(const Gdk::EventCrossing& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->leave_notify_event)
		result = g_class->leave_notify_event((GtkWidget*)instance_, event.gdk_event_crossing());
	return result;
}

bool
Gtk::WidgetSignals::on_configure_event(const Gdk::EventConfigure& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->configure_event)
		result = g_class->configure_event((GtkWidget*)instance_, event.gdk_event_configure());
	return result;
}

bool
Gtk::WidgetSignals::on_focus_in_event(const Gdk::EventFocus& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->focus_in_event)
		result = g_class->focus_in_event((GtkWidget*)instance_, event.gdk_event_focus());
	return result;
}

bool
Gtk::WidgetSignals::on_focus_out_event(const Gdk::EventFocus& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->focus_out_event)
		result = g_class->focus_out_event((GtkWidget*)instance_, event.gdk_event_focus());
	return result;
}

bool
Gtk::WidgetSignals::on_map_event(const Gdk::EventAny& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->map_event)
		result = g_class->map_event((GtkWidget*)instance_, event.gdk_event_any());
	return result;
}

bool
Gtk::WidgetSignals::on_unmap_event(const Gdk::EventAny& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->unmap_event)
		result = g_class->unmap_event((GtkWidget*)instance_, event.gdk_event_any());
	return result;
}

bool
Gtk::WidgetSignals::on_property_notify_event(const Gdk::EventProperty& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->property_notify_event)
		result = g_class->property_notify_event((GtkWidget*)instance_, event.gdk_event_property());
	return result;
}

bool
Gtk::WidgetSignals::on_selection_clear_event(const Gdk::EventSelection& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->selection_clear_event)
		result = g_class->selection_clear_event((GtkWidget*)instance_, event.gdk_event_selection());
	return result;
}

bool
Gtk::WidgetSignals::on_selection_request_event(const Gdk::EventSelection& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->selection_request_event)
		result = g_class->selection_request_event((GtkWidget*)instance_, event.gdk_event_selection());
	return result;
}

bool
Gtk::WidgetSignals::on_selection_notify_event(const Gdk::EventSelection& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->selection_notify_event)
		result = g_class->selection_notify_event((GtkWidget*)instance_, event.gdk_event_selection());
	return result;
}

bool
Gtk::WidgetSignals::on_proximity_in_event(const Gdk::EventProximity& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->proximity_in_event)
		result = g_class->proximity_in_event((GtkWidget*)instance_, event.gdk_event_proximity());
	return result;
}

bool
Gtk::WidgetSignals::on_proximity_out_event(const Gdk::EventProximity& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->proximity_out_event)
		result = g_class->proximity_out_event((GtkWidget*)instance_, event.gdk_event_proximity());
	return result;
}

bool
Gtk::WidgetSignals::on_visibility_notify_event(const Gdk::EventVisibility& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->visibility_notify_event)
		result = g_class->visibility_notify_event((GtkWidget*)instance_, event.gdk_event_visibility());
	return result;
}

bool
Gtk::WidgetSignals::on_client_event(const Gdk::EventClient& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->client_event)
		result = g_class->client_event((GtkWidget*)instance_, event.gdk_event_client());
	return result;
}

bool
Gtk::WidgetSignals::on_no_expose_event(const Gdk::EventAny& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->no_expose_event)
		result = g_class->no_expose_event((GtkWidget*)instance_, event.gdk_event_any());
	return result;
}

bool
Gtk::WidgetSignals::on_window_state_event(const Gdk::EventWindowState& event)
{
	bool result = false;
	GtkWidgetClass *g_class = WidgetClass::get_parent_class(instance_);
	if (g_class->window_state_event)
		result = g_class->window_state_event((GtkWidget*)instance_, event.gdk_event_window_state());
	return result;
}

/*  Gtk::WidgetClass
 */

void
Gtk::WidgetClass::init(GtkWidgetClass *g_class)
{
	g_class->show = &show_proxy;
	g_class->hide = &hide_proxy;
	g_class->map = &map_proxy;
	g_class->unmap = &unmap_proxy;
	g_class->realize = &realize_proxy;
	g_class->unrealize = &unrealize_proxy;
	g_class->size_request = &size_request_proxy;
	g_class->size_allocate = &size_allocate_proxy;
	g_class->state_changed = &state_changed_proxy;
	g_class->parent_set = &parent_set_proxy;
	g_class->hierarchy_changed = &hierarchy_changed_proxy;
	g_class->style_set = &style_set_proxy;
	g_class->direction_changed = &direction_changed_proxy;
	g_class->grab_notify = &grab_notify_proxy;
	g_class->child_notify = &child_notify_proxy;
	g_class->mnemonic_activate = &mnemonic_activate_proxy;
	g_class->grab_focus = &grab_focus_proxy;
	g_class->focus = &focus_proxy;
	g_class->screen_changed = &screen_changed_proxy;
	g_class->can_activate_accel = &can_activate_accel_proxy;
	g_class->selection_get = &selection_get_proxy;
	g_class->selection_received = &selection_received_proxy;
	g_class->drag_begin = &drag_begin_proxy;
	g_class->drag_end = &drag_end_proxy;
	g_class->drag_data_get = &drag_data_get_proxy;
	g_class->drag_data_delete = &drag_data_delete_proxy;
	g_class->drag_leave = &drag_leave_proxy;
	g_class->drag_motion = &drag_motion_proxy;
	g_class->drag_drop = &drag_drop_proxy;
	g_class->drag_data_received = &drag_data_received_proxy;
	g_class->event = &event_proxy;
	g_class->button_press_event = &button_press_event_proxy;
	g_class->button_release_event = &button_release_event_proxy;
	g_class->scroll_event = &scroll_event_proxy;
	g_class->motion_notify_event = &motion_notify_event_proxy;
	g_class->delete_event = &delete_event_proxy;
	g_class->destroy_event = &destroy_event_proxy;
	g_class->expose_event = &expose_event_proxy;
	g_class->key_press_event = &key_press_event_proxy;
	g_class->key_release_event = &key_release_event_proxy;
	g_class->enter_notify_event = &enter_notify_event_proxy;
	g_class->leave_notify_event = &leave_notify_event_proxy;
	g_class->configure_event = &configure_event_proxy;
	g_class->focus_in_event = &focus_in_event_proxy;
	g_class->focus_out_event = &focus_out_event_proxy;
	g_class->map_event = &map_event_proxy;
	g_class->unmap_event = &unmap_event_proxy;
	g_class->property_notify_event = &property_notify_event_proxy;
	g_class->selection_clear_event = &selection_clear_event_proxy;
	g_class->selection_request_event = &selection_request_event_proxy;
	g_class->selection_notify_event = &selection_notify_event_proxy;
	g_class->proximity_in_event = &proximity_in_event_proxy;
	g_class->proximity_out_event = &proximity_out_event_proxy;
	g_class->visibility_notify_event = &visibility_notify_event_proxy;
	g_class->client_event = &client_event_proxy;
	g_class->no_expose_event = &no_expose_event_proxy;
	g_class->window_state_event = &window_state_event_proxy;
}

GtkWidgetClass*
Gtk::WidgetClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_WIDGET_GET_CLASS(instance));
	return static_cast<GtkWidgetClass*>(ptr);
}

GType
Gtk::WidgetClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_WIDGET);
	}
	return type;
}

void*
Gtk::WidgetClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::WidgetClass::show_proxy(GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_show();
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->show)
			g_class->show(widget);
	}
}

void
Gtk::WidgetClass::hide_proxy(GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_hide();
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->hide)
			g_class->hide(widget);
	}
}

void
Gtk::WidgetClass::map_proxy(GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_map();
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->map)
			g_class->map(widget);
	}
}

void
Gtk::WidgetClass::unmap_proxy(GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_unmap();
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->unmap)
			g_class->unmap(widget);
	}
}

void
Gtk::WidgetClass::realize_proxy(GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_realize();
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->realize)
			g_class->realize(widget);
	}
}

void
Gtk::WidgetClass::unrealize_proxy(GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_unrealize();
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->unrealize)
			g_class->unrealize(widget);
	}
}

void
Gtk::WidgetClass::size_request_proxy(GtkWidget *widget, GtkRequisition *requisition)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_size_request(reinterpret_cast<Requisition*>(requisition));
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->size_request)
			g_class->size_request(widget, requisition);
	}
}

void
Gtk::WidgetClass::size_allocate_proxy(GtkWidget *widget, GtkAllocation *allocation)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_size_allocate(reinterpret_cast<Allocation&>(*allocation));
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->size_allocate)
			g_class->size_allocate(widget, allocation);
	}
}

void
Gtk::WidgetClass::state_changed_proxy(GtkWidget *widget, GtkStateType previous_state)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_state_changed((StateType)previous_state);
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->state_changed)
			g_class->state_changed(widget, previous_state);
	}
}

void
Gtk::WidgetClass::parent_set_proxy(GtkWidget *widget, GtkWidget *previous_parent)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_parent_set(G::Object::wrap<Widget>(previous_parent));
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->parent_set)
			g_class->parent_set(widget, previous_parent);
	}
}

void
Gtk::WidgetClass::hierarchy_changed_proxy(GtkWidget *widget, GtkWidget *previous_toplevel)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_hierarchy_changed(G::Object::wrap<Widget>(previous_toplevel));
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->hierarchy_changed)
			g_class->hierarchy_changed(widget, previous_toplevel);
	}
}

void
Gtk::WidgetClass::style_set_proxy(GtkWidget *widget, GtkStyle *previous_style)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr && static_cast<Widget*>(G::Object::pointer((GObject*)widget))->is_realized())
		static_cast<WidgetSignals*>(ptr)->on_style_set(G::Object::wrap<Style>(previous_style));
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->style_set)
			g_class->style_set(widget, previous_style);
	}
}

void
Gtk::WidgetClass::direction_changed_proxy(GtkWidget *widget, GtkTextDirection previous_direction)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_direction_changed((TextDirection)previous_direction);
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->direction_changed)
			g_class->direction_changed(widget, previous_direction);
	}
}

void
Gtk::WidgetClass::grab_notify_proxy(GtkWidget *widget, gboolean was_grabbed)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_grab_notify(was_grabbed);
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->grab_notify)
			g_class->grab_notify(widget, was_grabbed);
	}
}

void
Gtk::WidgetClass::child_notify_proxy(GtkWidget *widget, GParamSpec *pspec)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_child_notify(pspec);
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->child_notify)
			g_class->child_notify(widget, pspec);
	}
}

gboolean
Gtk::WidgetClass::mnemonic_activate_proxy(GtkWidget *widget, gboolean group_cycling)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		result = static_cast<WidgetSignals*>(ptr)->on_mnemonic_activate(group_cycling);
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->mnemonic_activate)
			result = g_class->mnemonic_activate(widget, group_cycling);
	}
	return result;
}

void
Gtk::WidgetClass::grab_focus_proxy(GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_grab_focus();
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->grab_focus)
			g_class->grab_focus(widget);
	}
}

gboolean
Gtk::WidgetClass::focus_proxy(GtkWidget *widget, GtkDirectionType direction)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		result = static_cast<WidgetSignals*>(ptr)->on_focus((DirectionType)direction);
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->focus)
			result = g_class->focus(widget, direction);
	}
	return result;
}

void
Gtk::WidgetClass::screen_changed_proxy(GtkWidget *widget, GdkScreen *previous_screen)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_screen_changed(G::Object::wrap<Gdk::Screen>(previous_screen));
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->screen_changed)
			g_class->screen_changed(widget, previous_screen);
	}
}

gboolean
Gtk::WidgetClass::can_activate_accel_proxy(GtkWidget *widget, guint signal_id)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		result = static_cast<WidgetSignals*>(ptr)->on_can_activate_accel(signal_id);
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->can_activate_accel)
			result = g_class->can_activate_accel(widget, signal_id);
	}
	return result;
}

gboolean
Gtk::WidgetClass::event_proxy(GtkWidget	*widget, GdkEvent *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event(event);
		result = static_cast<WidgetSignals*>(ptr)->on_event(tmp_event);
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->event)
			result = g_class->event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::button_press_event_proxy(GtkWidget *widget, GdkEventButton *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_button_press_event(*tmp_event.button());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->button_press_event)
			result = g_class->button_press_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::button_release_event_proxy(GtkWidget *widget, GdkEventButton *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_button_release_event(*tmp_event.button());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->button_release_event)
			result = g_class->button_release_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::scroll_event_proxy(GtkWidget *widget, GdkEventScroll *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_scroll_event(*tmp_event.scroll());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->scroll_event)
			result = g_class->scroll_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::motion_notify_event_proxy(GtkWidget *widget, GdkEventMotion *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_motion_notify_event(*tmp_event.motion());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->motion_notify_event)
			result = g_class->motion_notify_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::delete_event_proxy(GtkWidget *widget, GdkEventAny *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_delete_event(*tmp_event.any());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->delete_event)
			result = g_class->delete_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::destroy_event_proxy(GtkWidget *widget, GdkEventAny *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_destroy_event(*tmp_event.any());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->destroy_event)
			result = g_class->destroy_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::expose_event_proxy(GtkWidget *widget, GdkEventExpose *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_expose_event(*tmp_event.expose());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->expose_event)
			result = g_class->expose_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::key_press_event_proxy(GtkWidget *widget, GdkEventKey *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_key_press_event(*tmp_event.key());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->key_press_event)
			result = g_class->key_press_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::key_release_event_proxy(GtkWidget *widget, GdkEventKey *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_key_release_event(*tmp_event.key());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->key_release_event)
			result = g_class->key_release_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::enter_notify_event_proxy(GtkWidget *widget, GdkEventCrossing *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_enter_notify_event(*tmp_event.crossing());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->enter_notify_event)
			result = g_class->enter_notify_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::leave_notify_event_proxy(GtkWidget *widget, GdkEventCrossing *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_leave_notify_event(*tmp_event.crossing());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->leave_notify_event)
			result = g_class->leave_notify_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::configure_event_proxy(GtkWidget *widget, GdkEventConfigure *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_configure_event(*tmp_event.configure());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->configure_event)
			result = g_class->configure_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::focus_in_event_proxy(GtkWidget *widget, GdkEventFocus *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_focus_in_event(*tmp_event.focus_change());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->focus_in_event)
			result = g_class->focus_in_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::focus_out_event_proxy(GtkWidget *widget, GdkEventFocus *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_focus_out_event(*tmp_event.focus_change());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->focus_out_event)
			result = g_class->focus_out_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::map_event_proxy(GtkWidget	*widget, GdkEventAny *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_map_event(*tmp_event.any());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->map_event)
			result = g_class->map_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::unmap_event_proxy(GtkWidget *widget, GdkEventAny *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_unmap_event(*tmp_event.any());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->unmap_event)
			result = g_class->unmap_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::property_notify_event_proxy(GtkWidget *widget, GdkEventProperty *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_property_notify_event(*tmp_event.property());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->property_notify_event)
			result = g_class->property_notify_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::selection_clear_event_proxy(GtkWidget *widget, GdkEventSelection *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_selection_clear_event(*tmp_event.selection());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->selection_clear_event)
			result = g_class->selection_clear_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::selection_request_event_proxy(GtkWidget *widget, GdkEventSelection *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_selection_request_event(*tmp_event.selection());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->selection_request_event)
			result = g_class->selection_request_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::selection_notify_event_proxy(GtkWidget *widget, GdkEventSelection *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_selection_notify_event(*tmp_event.selection());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->selection_notify_event)
			result = g_class->selection_notify_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::proximity_in_event_proxy(GtkWidget *widget, GdkEventProximity *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_proximity_in_event(*tmp_event.proximity());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->proximity_in_event)
			result = g_class->proximity_in_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::proximity_out_event_proxy(GtkWidget *widget, GdkEventProximity *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_proximity_out_event(*tmp_event.proximity());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->proximity_out_event)
			result = g_class->proximity_out_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::visibility_notify_event_proxy(GtkWidget *widget, GdkEventVisibility *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_visibility_notify_event(*tmp_event.visibility());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->visibility_notify_event)
			result = g_class->visibility_notify_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::client_event_proxy(GtkWidget *widget, GdkEventClient *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_client_event(*tmp_event.client());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->client_event)
			result = g_class->client_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::no_expose_event_proxy(GtkWidget *widget, GdkEventAny *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_no_expose_event(*tmp_event.any());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->no_expose_event)
			result = g_class->no_expose_event(widget, event);
	}
	return result;
}

gboolean
Gtk::WidgetClass::window_state_event_proxy(GtkWidget *widget, GdkEventWindowState *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event((GdkEvent*)event);
		result = static_cast<WidgetSignals*>(ptr)->on_window_state_event(*tmp_event.window_state());
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->window_state_event)
			result = g_class->window_state_event(widget, event);
	}
	return result;
}

void
Gtk::WidgetClass::selection_get_proxy(GtkWidget *widget, GtkSelectionData *selection_data, guint info, guint time)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gtk::SelectionData tmp_selection_data(selection_data);
		static_cast<WidgetSignals*>(ptr)->on_selection_get(tmp_selection_data, info, time);
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->selection_get)
			g_class->selection_get(widget, selection_data, info, time);
	}
}

void
Gtk::WidgetClass::selection_received_proxy(GtkWidget *widget, GtkSelectionData *selection_data, guint time)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gtk::SelectionData tmp_selection_data(selection_data);
		static_cast<WidgetSignals*>(ptr)->on_selection_received(tmp_selection_data, time);
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->selection_received)
			g_class->selection_received(widget, selection_data, time);
	}
}

void
Gtk::WidgetClass::drag_begin_proxy(GtkWidget *widget, GdkDragContext *context)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_drag_begin(*G::Object::wrap<DragContext>(context));
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->drag_begin)
			g_class->drag_begin(widget, context);
	}
}

void
Gtk::WidgetClass::drag_end_proxy(GtkWidget *widget, GdkDragContext *context)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_drag_end(*G::Object::wrap<DragContext>(context));
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->drag_end)
			g_class->drag_end(widget, context);
	}
}

void
Gtk::WidgetClass::drag_data_get_proxy(GtkWidget *widget, GdkDragContext *context, GtkSelectionData *selection_data, guint info, guint time)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gtk::SelectionData tmp_selection_data(selection_data);
		static_cast<WidgetSignals*>(ptr)->on_drag_data_get(*G::Object::wrap<DragContext>(context), tmp_selection_data, info, time);
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->drag_data_get)
			g_class->drag_data_get(widget, context, selection_data, info, time);
	}
}

void
Gtk::WidgetClass::drag_data_delete_proxy(GtkWidget *widget, GdkDragContext *context)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_drag_data_delete(*G::Object::wrap<DragContext>(context));
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->drag_data_delete)
			g_class->drag_data_delete(widget, context);
	}
}

void
Gtk::WidgetClass::drag_leave_proxy(GtkWidget *widget, GdkDragContext *context, guint time)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WidgetSignals*>(ptr)->on_drag_leave(*G::Object::wrap<DragContext>(context), time);
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->drag_leave)
			g_class->drag_leave(widget, context, time);
	}
}

gboolean
Gtk::WidgetClass::drag_motion_proxy(GtkWidget *widget, GdkDragContext *context, gint x, gint y, guint time)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		result = static_cast<WidgetSignals*>(ptr)->on_drag_motion(*G::Object::wrap<DragContext>(context),x, y, time);
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->drag_motion)
			result = g_class->drag_motion(widget, context, x, y, time);
	}
	return result;
}

gboolean
Gtk::WidgetClass::drag_drop_proxy(GtkWidget *widget, GdkDragContext *context, gint x, gint y, guint time)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
		result = static_cast<WidgetSignals*>(ptr)->on_drag_drop(*G::Object::wrap<DragContext>(context), x, y, time);
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->drag_drop)
			result = g_class->drag_drop(widget, context, x, y, time);
	}
	return result;
}

void
Gtk::WidgetClass::drag_data_received_proxy(GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *selection_data, guint info, guint time)
{
	void *ptr = g_object_get_qdata((GObject*)widget, G::ObjectSignals::quark());
	if (ptr)
	{
		Gtk::SelectionData tmp_selection_data(selection_data);
		static_cast<WidgetSignals*>(ptr)->on_drag_data_received(*G::Object::wrap<DragContext>(context),
		                                                        x, y, tmp_selection_data, info, time);
	}
	else
	{
		GtkWidgetClass *g_class = WidgetClass::get_parent_class(widget);
		if (g_class->drag_data_received)
			g_class->drag_data_received(widget, context, x, y, selection_data, info, time);
	}
}

