/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/// @file gfc/atk/gobjectaccessible.hh
/// @brief An AtkGObjectAccessible C++ wrapper interface.
///
/// Provides GObjectAccessible, an object class derived from Atk::Object that can be used
/// as a basis for implementing accessible objects.

#ifndef GFC_ATK_GOBJECT_ACCESSIBLE_HH
#define GFC_ATK_GOBJECT_ACCESSIBLE_HH

#ifndef GFC_ATK_OBJECT_HH
#include <gfc/atk/object.hh>
#endif

#ifndef __ATK_GOBJECT_ACCESSIBLE_H__
#include <atk/atkgobjectaccessible.h>
#endif

namespace GFC {

namespace G {
class Object;
}

namespace Atk {

/// @class GObjectAccessible gobjectaccessible.hh gfc/atk/gobjectaccessible.hh
/// @brief An AtkGObjectAccessible C++ wrapper class.
///
/// This object class is derived from Atk::Object. It can be used as a basis for implementing
/// accessible objects for G::Objects which are not derived from Gtk::Widget. One example of
/// its use is in providing an accessible object for GnomeCanvasItem in the GAIL library.

class GObjectAccessible : public Atk::Object
{
	friend class G::Object;

	GObjectAccessible(const GObjectAccessible&);
	GObjectAccessible& operator=(const GObjectAccessible&);

protected:
/// @name Constructors
/// @{

	explicit GObjectAccessible(AtkGObjectAccessible *object, bool owns_reference = true);
	///< Construct a new GObjectAccessible from an existing AtkGObjectAccessible.
	///< @param object A pointer to a AtkGObjectAccessible.
	///< @param owns_reference Set false if the initial reference count is floating, set true if it's not.
	///<
	///< <BR>The <EM>object</EM> can be a newly created AtkGObjectAccessible or an existing
	///< AtkGObjectAccessible. (see G::Object::Object).

/// @}

public:
/// @name Constructors
/// @{

	virtual ~GObjectAccessible();
	///< Destructor.

/// @}

	static Object* for_object(G::Object& object);
	///< Gets the accessible object for the specified G::Object.
	///< @param object A G::Object.
	///< @return An Atk::Object which is the accessible object for <EM>object</EM>.

/// @name Accessors
/// @{

	AtkGObjectAccessible* atk_gobject_accessible() const;
	///< Get a pointer to the AtkGObjectAccessible structure.

	operator AtkGObjectAccessible* () const;
	///< Conversion operator; safely converts a GObjectAccessible to an AtkGObjectAccessible pointer.

	G::Object* get_object() const;
	///< Gets the G::Object for this accessible object.
	///< @return A G::Object which is the object for this accessible object.

/// @}
};

} // namespace Atk

} // namespace GFC

#include <gfc/atk/inline/gobjectaccessible.inl>

#endif // GFC_ATK_GOBJECT_ACCESSIBLE_HH

