/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  hypertext.inl - Atk::Hypertext inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline AtkHypertext*
GFC::Atk::Hypertext::atk_hypertext() const
{
	return reinterpret_cast<AtkHypertext*>(instance_);
}

inline GFC::Atk::Hypertext::operator AtkHypertext* () const
{
	return this ? atk_hypertext() : 0;
}

inline int
GFC::Atk::Hypertext::get_n_links(int char_index) const
{
	return atk_hypertext_get_n_links(atk_hypertext());
}

inline int
GFC::Atk::Hypertext::get_link_index(int char_index) const
{
	return atk_hypertext_get_link_index(atk_hypertext(), char_index);
}

inline const GFC::Atk::Hypertext::LinkSelectedSignalProxy
GFC::Atk::Hypertext::sig_link_selected()
{
	return LinkSelectedSignalProxy(this, &link_selected_signal);
}

