/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  displaymanagersignals.cc - Gdk::DisplayManager virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "displaymanager.hh"
#include "displaymanagersignals.hh"
#include "private/displaymanagerclass.hh"

using namespace GFC;

/*  Gdk::DisplayManagerSignals
 */

Gdk::DisplayManagerSignals::DisplayManagerSignals(DisplayManager *display_manager)
: G::ObjectSignals(display_manager)
{
	Gdk::DisplayManagerClass::init(GDK_DISPLAY_MANAGER_GET_CLASS(display_manager->gdk_display_manager()));
}

Gdk::DisplayManagerSignals::~DisplayManagerSignals()
{
}
	
void
Gdk::DisplayManagerSignals::on_display_opened(Display& display)
{
	GdkDisplayManagerClass *g_class = DisplayManagerClass::get_parent_class(instance_);
	if (g_class->display_opened)
		g_class->display_opened((GdkDisplayManager*)instance_, display.gdk_display());
}

/*  Gdk::DisplayManagerClass
 */

void
Gdk::DisplayManagerClass::init(GdkDisplayManagerClass *g_class)
{
	g_class->display_opened = &display_opened_proxy;
}

GdkDisplayManagerClass*
Gdk::DisplayManagerClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GDK_DISPLAY_MANAGER_GET_CLASS(instance));
	return static_cast<GdkDisplayManagerClass*>(ptr);
}

GType
Gdk::DisplayManagerClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GDK_TYPE_DISPLAY_MANAGER);
	}
	return type;
}

void*
Gdk::DisplayManagerClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gdk::DisplayManagerClass::display_opened_proxy(GdkDisplayManager *display_manager, GdkDisplay *display)
{
	void *ptr = g_object_get_qdata((GObject*)display_manager, G::ObjectSignals::quark());
	if (ptr)
		static_cast<DisplayManagerSignals*>(ptr)->on_display_opened(*G::Object::wrap<Display>(display));
	else
	{
		GdkDisplayManagerClass *g_class = DisplayManagerClass::get_parent_class(display_manager);
		if (g_class->display_opened)
			g_class->display_opened(display_manager, display);
	}
}

