/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  screensignals.cc - Gdk::Screen virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "screen.hh"
#include "screensignals.hh"
#include "private/screenclass.hh"

using namespace GFC;

/*  Gdk::ScreenSignals
 */

Gdk::ScreenSignals::ScreenSignals(Screen *screen)
: G::ObjectSignals(screen)
{
	Gdk::ScreenClass::init(GDK_SCREEN_GET_CLASS(screen->gdk_screen()));
}

Gdk::ScreenSignals::~ScreenSignals()
{
}
	
void
Gdk::ScreenSignals::on_size_changed()
{
	GdkScreenClass *g_class = ScreenClass::get_parent_class(instance_);
	if (g_class->size_changed)
		g_class->size_changed((GdkScreen*)instance_);
}

/*  Gdk::ScreenClass
 */

void
Gdk::ScreenClass::init(GdkScreenClass *g_class)
{
	g_class->size_changed = &size_changed_proxy;
}

GdkScreenClass*
Gdk::ScreenClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GDK_SCREEN_GET_CLASS(instance));
	return static_cast<GdkScreenClass*>(ptr);
}

GType
Gdk::ScreenClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GDK_TYPE_SCREEN);
	}
	return type;
}

void*
Gdk::ScreenClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gdk::ScreenClass::size_changed_proxy(GdkScreen *screen)
{
	void *ptr = g_object_get_qdata((GObject*)screen, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ScreenSignals*>(ptr)->on_size_changed();
	else
	{
		GdkScreenClass *g_class = ScreenClass::get_parent_class(screen);
		if (g_class->size_changed)
			g_class->size_changed(screen);
	}
}

