/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  celleditable.cc - GtkCellEditable C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "celleditable.hh"
#include "private/marshal.hh"
#include "../gdk/events.hh"

using namespace GFC;

/*  Gtk::CellEditable
 */

Gtk::CellEditable::CellEditable()
{
}
	
Gtk::CellEditable::~CellEditable()
{
}
	
void
Gtk::CellEditable::start_editing(const Gdk::Event *event)
{
	gtk_cell_editable_start_editing(gtk_cell_editable(), *event);
}

/*  Gtk::CellEditable signals
 */

const Gtk::CellEditable::EditingDoneSignalType Gtk::CellEditable::editing_done_signal("editing_done", (GCallback)&G::Marshal::void_callback);

const Gtk::CellEditable::RemoveWidgetSignalType Gtk::CellEditable::remove_widget_signal("remove_widget", (GCallback)&G::Marshal::void_callback);

