/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  cellrenderersignals.cc - Gtk::CellRenderer virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "cellrenderer.hh"
#include "cellrenderersignals.hh"
#include "private/cellrendererclass.hh"

using namespace GFC;

/*  Gtk::CellRendererSignals
 */

Gtk::CellRendererSignals::CellRendererSignals(CellRenderer *cell)
: ObjectSignals(cell)
{
	Gtk::CellRendererClass::init(GTK_CELL_RENDERER_GET_CLASS(cell->gtk_cell_renderer()));
}

Gtk::CellRendererSignals::~CellRendererSignals() 
{
}
	
void
Gtk::CellRendererSignals::on_editing_canceled()
{
	GtkCellRendererClass *g_class = CellRendererClass::get_parent_class(instance_);
	if (g_class->editing_canceled)
		g_class->editing_canceled((GtkCellRenderer*)instance_);
}

/*  Gtk::CellRendererClass
 */

void
Gtk::CellRendererClass::init(GtkCellRendererClass *g_class)
{
	g_class->editing_canceled = &editing_canceled_proxy;
}

GtkCellRendererClass*
Gtk::CellRendererClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_CELL_RENDERER_GET_CLASS(instance));
	return static_cast<GtkCellRendererClass*>(ptr);
}

GType
Gtk::CellRendererClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CELL_RENDERER);
	}
	return type;
}

void*
Gtk::CellRendererClass::create()
{
	return g_object_new(get_type(), 0);
}

void 
Gtk::CellRendererClass::editing_canceled_proxy(GtkCellRenderer *cell)
{
	void *ptr = g_object_get_qdata((GObject*)cell, G::ObjectSignals::quark());
	if (ptr)
		static_cast<CellRendererSignals*>(ptr)->on_editing_canceled();
	else
	{
		GtkCellRendererClass *g_class = CellRendererClass::get_parent_class(cell);
		if (g_class->editing_canceled)
			g_class->editing_canceled(cell);
	}
}

