/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  colorbuttonsignals.cc - Gtk::ColorButton virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "colorbutton.hh"
#include "colorbuttonsignals.hh"
#include "private/colorbuttonclass.hh"

using namespace GFC;

/*  Gtk::ColorButtonSignals
 */

Gtk::ColorButtonSignals::ColorButtonSignals(ColorButton *color_button)
: ButtonSignals(color_button)
{
	Gtk::ColorButtonClass::init(GTK_COLOR_BUTTON_GET_CLASS(color_button->gtk_color_button()));
}

Gtk::ColorButtonSignals::~ColorButtonSignals()
{
}

void
Gtk::ColorButtonSignals::on_color_set()
{
	GtkColorButtonClass *g_class = ColorButtonClass::get_parent_class(instance_);
	if (g_class->color_set)
		g_class->color_set((GtkColorButton*)instance_);
}

/*  Gtk::ColorButtonClass
 */

void
Gtk::ColorButtonClass::init(GtkColorButtonClass *g_class)
{
	g_class->color_set = &color_set_proxy;
}

GtkColorButtonClass*
Gtk::ColorButtonClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_COLOR_BUTTON_GET_CLASS(instance));
	return static_cast<GtkColorButtonClass*>(ptr);
}

GType
Gtk::ColorButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_COLOR_BUTTON);
	}
	return type;
}

void*
Gtk::ColorButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ColorButtonClass::color_set_proxy(GtkColorButton *color_button)
{
	void *ptr = g_object_get_qdata((GObject*)color_button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ColorButtonSignals*>(ptr)->on_color_set();
	else
	{
		GtkColorButtonClass *g_class = ColorButtonClass::get_parent_class(color_button);
		if (g_class->color_set)
			g_class->color_set(color_button);
	}
}

