/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  dialog.inl - Gtk::Dialog inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkDialog*
GFC::Gtk::Dialog::gtk_dialog() const
{
	return reinterpret_cast<GtkDialog*>(instance_);
}

inline GFC::Gtk::Dialog::operator GtkDialog* () const
{
	return this ? gtk_dialog() : 0;
}

inline bool
GFC::Gtk::Dialog::get_has_separator() const
{
	return gtk_dialog_get_has_separator(gtk_dialog());
}

inline void
GFC::Gtk::Dialog::set_response_sensitive(int response_id, bool setting)
{
	gtk_dialog_set_response_sensitive(gtk_dialog(), response_id, setting);
}

inline void
GFC::Gtk::Dialog::set_default_response(int response_id)
{
	gtk_dialog_set_default_response(gtk_dialog(), response_id);
}

inline void
GFC::Gtk::Dialog::response(int response_id)
{
	gtk_dialog_response(gtk_dialog(), response_id);
}

inline int
GFC::Gtk::Dialog::run()
{
	return gtk_dialog_run(gtk_dialog());
}

inline void
GFC::Gtk::Dialog::set_has_separator(bool setting)
{
	gtk_dialog_set_has_separator(gtk_dialog(), setting);
}

inline const GFC::Gtk::Dialog::ResponseSignalProxy 
GFC::Gtk::Dialog::sig_response()
{
	return ResponseSignalProxy(this, &response_signal);
}

inline const GFC::Gtk::Dialog::CloseSignalProxy 
GFC::Gtk::Dialog::sig_close()
{
	return CloseSignalProxy(this, &close_signal);
}

