/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  editable.inl - Gtk::Editable inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkEditable*
GFC::Gtk::Editable::gtk_editable() const
{
	return reinterpret_cast<GtkEditable*>(instance_);
}

inline GFC::Gtk::Editable::operator GtkEditable* () const
{
	return this ? ((GtkEditable*)instance_) : 0;
}

inline bool
GFC::Gtk::Editable::get_selection_bounds(int *start, int *end) const
{
	return gtk_editable_get_selection_bounds(gtk_editable(), start, end);
}

inline int
GFC::Gtk::Editable::get_position() const
{
	return gtk_editable_get_position(gtk_editable());
}

inline bool
GFC::Gtk::Editable::get_editable() const
{
	return gtk_editable_get_editable(gtk_editable());
}

inline void
GFC::Gtk::Editable::select_region (int start, int end)
{
	gtk_editable_select_region(gtk_editable(), start, end);
}

inline void
GFC::Gtk::Editable::insert_text(const char *new_text, int& position)
{
	gtk_editable_insert_text(gtk_editable(), new_text, -1, &position);
}

inline void
GFC::Gtk::Editable::delete_text(int start_pos, int end_pos)
{
	gtk_editable_delete_text(gtk_editable(), start_pos, end_pos);
}

inline void
GFC::Gtk::Editable::cut_clipboard()
{
	gtk_editable_cut_clipboard(gtk_editable());
}

inline void
GFC::Gtk::Editable::copy_clipboard()
{
	gtk_editable_copy_clipboard(gtk_editable());
}

inline void
GFC::Gtk::Editable::paste_clipboard()
{
	gtk_editable_paste_clipboard(gtk_editable());
}

inline void
GFC::Gtk::Editable::delete_selection()
{
	gtk_editable_delete_selection(gtk_editable());
}

inline void
GFC::Gtk::Editable::set_position(int position)
{
	gtk_editable_set_position(gtk_editable(), position);
}

inline void
GFC::Gtk::Editable::set_editable(bool is_editable)
{
	gtk_editable_set_editable(gtk_editable(), is_editable);
}

inline const GFC::Gtk::Editable::InsertTextSignalProxy
GFC::Gtk::Editable::sig_insert_text()
{
	return InsertTextSignalProxy(this, &insert_text_signal);
}

inline const GFC::Gtk::Editable::DeleteTextSignalProxy
GFC::Gtk::Editable::sig_delete_text()
{
	return DeleteTextSignalProxy(this, &delete_text_signal);
}

inline const GFC::Gtk::Editable::ChangedSignalProxy
GFC::Gtk::Editable::sig_changed()
{
	return ChangedSignalProxy(this, &changed_signal);
}

