/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  entrycompletion.inl - Gtk::EntryCompletion inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkEntryCompletion*
GFC::Gtk::EntryCompletion::gtk_entry_completion() const
{
	return reinterpret_cast<GtkEntryCompletion*>(instance_);
}

inline GFC::Gtk::EntryCompletion::operator GtkEntryCompletion* () const
{
	return this ? gtk_entry_completion() : 0;
}

inline int 
GFC::Gtk::EntryCompletion::get_minimum_key_length() const 
{
	return gtk_entry_completion_get_minimum_key_length(gtk_entry_completion());
}

inline void 
GFC::Gtk::EntryCompletion::set_minimum_key_length(int length)
{
	gtk_entry_completion_set_minimum_key_length(gtk_entry_completion(), length);
}

inline void 
GFC::Gtk::EntryCompletion::complete()
{
	gtk_entry_completion_complete(gtk_entry_completion());
}

inline void 
GFC::Gtk::EntryCompletion::insert_action_text(int index, const char *text)
{
	gtk_entry_completion_insert_action_text(gtk_entry_completion(), index, text);
}

inline void 
GFC::Gtk::EntryCompletion::insert_action_markup(int index, const char *markup)
{
	gtk_entry_completion_insert_action_markup(gtk_entry_completion(), index, markup);
}

inline void 
GFC::Gtk::EntryCompletion::delete_action(int index)
{
	gtk_entry_completion_delete_action(gtk_entry_completion(), index);
}
	
inline void 
GFC::Gtk::EntryCompletion::set_text_column(int column)
{
	gtk_entry_completion_set_text_column(gtk_entry_completion(), column);
}

inline const GFC::Gtk::EntryCompletion::MatchSelectedSignalProxy
GFC::Gtk::EntryCompletion::sig_match_selected()
{
	return MatchSelectedSignalProxy(this, &match_selected_signal);
}

inline const GFC::Gtk::EntryCompletion::ActionActivatedSignalProxy
GFC::Gtk::EntryCompletion::sig_action_activated()
{
	return ActionActivatedSignalProxy(this, &action_activated_signal);
}

