/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  textbuffersignals.cc - Gtk::TextBuffer virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "textbuffer.hh"
#include "textbuffersignals.hh"
#include "private/textbufferclass.hh"
#include "../gdk-pixbuf/pixbuf.hh"

using namespace GFC;

/*  Gtk::TextBufferSignals
 */

Gtk::TextBufferSignals::TextBufferSignals(TextBuffer *buffer)
: G::ObjectSignals(buffer)
{
	Gtk::TextBufferClass::init(GTK_TEXT_BUFFER_GET_CLASS(buffer->gtk_text_buffer()));
}
	
Gtk::TextBufferSignals::~TextBufferSignals()
{
}
	
void
Gtk::TextBufferSignals::on_insert_text(TextIter& pos, const String& text)
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->insert_text)
		g_class->insert_text((GtkTextBuffer*)instance_, pos.gtk_text_iter(), text.c_str(), text.size());
}

void
Gtk::TextBufferSignals::on_insert_pixbuf(TextIter& pos, Gdk::Pixbuf& pixbuf)
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->insert_pixbuf)
		g_class->insert_pixbuf((GtkTextBuffer*)instance_, pos.gtk_text_iter(), pixbuf.gdk_pixbuf());
}

void
Gtk::TextBufferSignals::on_insert_child_anchor(TextIter& pos, TextChildAnchor& anchor)
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->insert_child_anchor)
		g_class->insert_child_anchor((GtkTextBuffer*)instance_, pos.gtk_text_iter(), anchor.gtk_text_child_anchor());
}

void
Gtk::TextBufferSignals::on_delete_range(TextIter& start, TextIter& end)
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->delete_range)
		g_class->delete_range((GtkTextBuffer*)instance_, start.gtk_text_iter(), end.gtk_text_iter());
}

void
Gtk::TextBufferSignals::on_changed()
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->changed)
		g_class->changed((GtkTextBuffer*)instance_);
}

void
Gtk::TextBufferSignals::on_modified_changed()
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->modified_changed)
		g_class->modified_changed((GtkTextBuffer*)instance_);
}

void
Gtk::TextBufferSignals::on_mark_set(const TextIter& location, TextMark& mark)
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->mark_set)
		g_class->mark_set((GtkTextBuffer*)instance_, location.gtk_text_iter(), mark.gtk_text_mark());
}

void
Gtk::TextBufferSignals::on_mark_deleted(TextMark& mark)
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->mark_deleted)
		g_class->mark_deleted((GtkTextBuffer*)instance_, mark.gtk_text_mark());
}

void
Gtk::TextBufferSignals::on_apply_tag(TextTag& tag, const TextIter& start_char, const TextIter& end_char)
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->apply_tag)
		g_class->apply_tag((GtkTextBuffer*)instance_, tag.gtk_text_tag(), start_char.gtk_text_iter(), end_char.gtk_text_iter());
}

void
Gtk::TextBufferSignals::on_remove_tag(TextTag& tag, const TextIter& start_char, const TextIter& end_char)
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->remove_tag)
		g_class->remove_tag((GtkTextBuffer*)instance_, tag.gtk_text_tag(), start_char.gtk_text_iter(), end_char.gtk_text_iter());
}

void
Gtk::TextBufferSignals::on_begin_user_action()
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->begin_user_action)
		g_class->begin_user_action((GtkTextBuffer*)instance_);
}

void
Gtk::TextBufferSignals::on_end_user_action()
{
	GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(instance_);
	if (g_class->end_user_action)
		g_class->end_user_action((GtkTextBuffer*)instance_);
}

/*  Gtk::TextBufferClass
 */

void
Gtk::TextBufferClass::init(GtkTextBufferClass *g_class)
{
	g_class->insert_text = &insert_text_proxy;
	g_class->insert_pixbuf = &insert_pixbuf_proxy;
	g_class->insert_child_anchor = &insert_child_anchor_proxy;
	g_class->delete_range = &delete_range_proxy;
	g_class->changed = &changed_proxy;
	g_class->modified_changed = &modified_changed_proxy;
	g_class->mark_set = &mark_set_proxy;
	g_class->mark_deleted = &mark_deleted_proxy;
	g_class->apply_tag = &apply_tag_proxy;
	g_class->remove_tag = &remove_tag_proxy;
	g_class->begin_user_action = &begin_user_action_proxy;
	g_class->end_user_action = &end_user_action_proxy;
}

GtkTextBufferClass*
Gtk::TextBufferClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TEXT_BUFFER_GET_CLASS(instance));
	return static_cast<GtkTextBufferClass*>(ptr);
}

GType
Gtk::TextBufferClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TEXT_BUFFER);
	}
	return type;
}

void*
Gtk::TextBufferClass::create(GtkTextTagTable *table)
{
	return g_object_new(get_type(), "tag_table", table, 0);
}

void
Gtk::TextBufferClass::insert_text_proxy(GtkTextBuffer *buffer, GtkTextIter *pos, const gchar *text, gint length)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
	{
		TextIter tmp_pos(pos);
		String tmp_text(text, length);
		static_cast<TextBufferSignals*>(ptr)->on_insert_text(tmp_pos, tmp_text);
	}
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->insert_text)
			g_class->insert_text(buffer, pos, text, length);
	}
}

void
Gtk::TextBufferClass::insert_pixbuf_proxy(GtkTextBuffer *buffer, GtkTextIter *pos, GdkPixbuf *pixbuf)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
	{
		TextIter tmp_pos(pos);
		static_cast<TextBufferSignals*>(ptr)->on_insert_pixbuf(tmp_pos, *G::Object::wrap<Gdk::Pixbuf>(pixbuf));
	}
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->insert_pixbuf)
			g_class->insert_pixbuf(buffer, pos, pixbuf);
	}
}

void
Gtk::TextBufferClass::insert_child_anchor_proxy(GtkTextBuffer *buffer, GtkTextIter *pos, GtkTextChildAnchor *anchor)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
	{
		TextChildAnchor *tmp_anchor = G::Object::wrap<TextChildAnchor>(anchor);
		TextIter tmp_pos(pos);
		static_cast<TextBufferSignals*>(ptr)->on_insert_child_anchor(tmp_pos, *tmp_anchor);
	}
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->insert_child_anchor)
			g_class->insert_child_anchor(buffer, pos, anchor);
	}
}

void
Gtk::TextBufferClass::delete_range_proxy(GtkTextBuffer *buffer, GtkTextIter *start, GtkTextIter *end)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
	{
		TextIter tmp_start(start);
		TextIter tmp_end(end);
		static_cast<TextBufferSignals*>(ptr)->on_delete_range(tmp_start, tmp_end);
	}
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->delete_range)
			g_class->delete_range(buffer, start, end);
	}
}

void
Gtk::TextBufferClass::changed_proxy(GtkTextBuffer *buffer)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TextBufferSignals*>(ptr)->on_changed();
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->changed)
			g_class->changed(buffer);
	}
}

void
Gtk::TextBufferClass::modified_changed_proxy(GtkTextBuffer *buffer)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TextBufferSignals*>(ptr)->on_modified_changed();
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->modified_changed)
			g_class->modified_changed(buffer);
	}
}

void
Gtk::TextBufferClass::mark_set_proxy(GtkTextBuffer *buffer, const GtkTextIter *location, GtkTextMark *mark)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
	{
		TextIter tmp_location(const_cast<GtkTextIter*>(location));
		static_cast<TextBufferSignals*>(ptr)->on_mark_set(tmp_location, *G::Object::wrap<TextMark>(mark));
	}
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->mark_set)
			g_class->mark_set(buffer, location, mark);
	}
}

void
Gtk::TextBufferClass::mark_deleted_proxy(GtkTextBuffer *buffer, GtkTextMark *mark)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TextBufferSignals*>(ptr)->on_mark_deleted(*G::Object::wrap<TextMark>(mark));
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->mark_deleted)
			g_class->mark_deleted(buffer, mark);
	}
}

void
Gtk::TextBufferClass::apply_tag_proxy(GtkTextBuffer *buffer, GtkTextTag *tag, const GtkTextIter *start_char, const GtkTextIter *end_char)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
	{
		TextTag *tmp_tag = G::Object::wrap<TextTag>(tag);
		TextIter tmp_start_char(const_cast<GtkTextIter*>(start_char));
		TextIter tmp_end_char(const_cast<GtkTextIter*>(end_char));
		static_cast<TextBufferSignals*>(ptr)->on_apply_tag(*tmp_tag, tmp_start_char, tmp_end_char);
	}
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->apply_tag)
			g_class->apply_tag(buffer, tag, start_char, end_char);
	}
}

void
Gtk::TextBufferClass::remove_tag_proxy(GtkTextBuffer *buffer, GtkTextTag *tag, const GtkTextIter *start_char, const GtkTextIter *end_char)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
	{
		TextTag *tmp_tag = G::Object::wrap<TextTag>(tag);
		TextIter tmp_start_char(const_cast<GtkTextIter*>(start_char));
		TextIter tmp_end_char(const_cast<GtkTextIter*>(end_char));
		static_cast<TextBufferSignals*>(ptr)->on_remove_tag(*tmp_tag, tmp_start_char, tmp_end_char);
	}
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->remove_tag)
			g_class->remove_tag(buffer, tag, start_char, end_char);
	}
}

void
Gtk::TextBufferClass::begin_user_action_proxy(GtkTextBuffer *buffer)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TextBufferSignals*>(ptr)->on_begin_user_action();
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->begin_user_action)
			g_class->begin_user_action(buffer);
	}
}

void
Gtk::TextBufferClass::end_user_action_proxy(GtkTextBuffer *buffer)
{
	void *ptr = g_object_get_qdata((GObject*)buffer, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TextBufferSignals*>(ptr)->on_end_user_action();
	else
	{
		GtkTextBufferClass *g_class = TextBufferClass::get_parent_class(buffer);
		if (g_class->end_user_action)
			g_class->end_user_action(buffer);
	}
}

