/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  toolitem.cc - GtkToolItem C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "toolitem.hh"
#include "private/toolitemclass.hh"
#include "private/marshal.hh"
#include "tooltips.hh"

using namespace GFC;

/*  Gtk::ToolItem
 */

Gtk::ToolItem::ToolItem(GtkToolItem *tool_item, bool owns_reference)
: Gtk::Bin((GtkBin*)tool_item, owns_reference)
{
}

Gtk::ToolItem::ToolItem()
: Bin((GtkBin*)ToolItemClass::create())
{
}

Gtk::ToolItem::ToolItem(Widget& widget)
: Bin((GtkBin*)ToolItemClass::create())
{
	add(widget);
}

Gtk::ToolItem::~ToolItem()
{
}

Gtk::Widget* 
Gtk::ToolItem::get_proxy_menu_item(const char *menu_item_id) const
{
	GtkWidget *proxy = gtk_tool_item_get_proxy_menu_item(gtk_tool_item(), menu_item_id);
	return proxy ? G::Object::wrap<Widget>(proxy) : 0;
}
	
Gtk::Widget* 
Gtk::ToolItem::get_proxy_menu_item(const String& menu_item_id) const
{
	return get_proxy_menu_item(menu_item_id.c_str());
}

Gtk::Widget* 
Gtk::ToolItem::retrieve_proxy_menu_item() const
{
	GtkWidget *proxy = gtk_tool_item_retrieve_proxy_menu_item(gtk_tool_item());
	return proxy ? G::Object::wrap<Widget>(proxy) : 0;
}

void 
Gtk::ToolItem::set_tooltip(Tooltips& tooltips, const char *tip_text, const char *tip_private)
{
	gtk_tool_item_set_tooltip(gtk_tool_item(), tooltips.gtk_tooltips(), tip_text, tip_private);
}
	
void 
Gtk::ToolItem::set_tooltip(Tooltips& tooltips, const String& tip_text, const String& tip_private)
{
	set_tooltip(tooltips, tip_text.c_str(), tip_private.c_str());
}

void 
Gtk::ToolItem::set_proxy_menu_item(const char *menu_item_id, Widget *menu_item)
{
	gtk_tool_item_set_proxy_menu_item(gtk_tool_item(), menu_item_id, *menu_item);
}
	
void 
Gtk::ToolItem::set_proxy_menu_item(const String& menu_item_id, Widget *menu_item)
{
	gtk_tool_item_set_proxy_menu_item(gtk_tool_item(), menu_item_id.c_str(), *menu_item);
}

/*  Gtk::ToolItem signals
 */

const Gtk::ToolItem::CreateMenuProxySignalType Gtk::ToolItem::create_menu_proxy_signal("create_menu_proxy", (GCallback)&Marshal::bool_callback);

const Gtk::ToolItem::ToolbarReconfiguredSignalType Gtk::ToolItem::toolbar_reconfigured_signal("toolbar_reconfigured", (GCallback)&G::Marshal::void_callback);

const Gtk::ToolItem::SetTooltipSignalType Gtk::ToolItem::set_tooltip_signal("set_tooltip", (GCallback)&Marshal::bool_tooltips_string_string_callback);

