/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/// @file gfc/gtk/treesortablesignals.hh
/// @brief Gtk::TreeSortable virtual signal handlers.
///
/// Provides Gtk::TreeSortableSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Gtk::TreeSortable objects.

#ifndef GFC_GTK_TREE_SORTABLE_SIGNALS_HH
#define GFC_GTK_TREE_SORTABLE_SIGNALS_HH

#ifndef GFC_G_TYPE_HH
#include <gfc/glib/type.hh>
#endif

namespace GFC {

namespace Gtk {

/// @class TreeSortableSignals treesortablesignals.hh gfc/gtk/treesortablesignals.hh
/// @brief Abstract base class that implements the virtual signal handlers for Gtk::TreeSortable.

class TreeSortableSignals : public virtual G::TypeInterface
{
protected:
/// @name Constructors
/// @{

	TreeSortableSignals(TreeSortable *sortable);
	///< Constructs a new TreeSortableSignals object.
	///< @param sortable A TreeSortable object inheriting the TreeSortableSignals implementation.
	
	virtual ~TreeSortableSignals() = 0;
	///< Destructor.

/// @}

public:
/// @name Signal Handlers
/// @{

	virtual void on_sort_column_changed();
	///< Called whenever the current sort column is changed.

/// @}
};

} // namespace Gtk

} // namespace GFC

#endif // GFC_GTK_TREE_SORTABLE_SIGNALS_HH

