/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  uimanagersignals.cc - Gtk::UIManager virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "uimanager.hh"
#include "uimanagersignals.hh"
#include "private/uimanagerclass.hh"
#include "accelgroup.hh"
#include "widget.hh"

using namespace GFC;

/*  Gtk::UIManagerSignals
 */

Gtk::UIManagerSignals::UIManagerSignals(UIManager *ui_manager)
: G::ObjectSignals(ui_manager)
{
	Gtk::UIManagerClass::init(GTK_UI_MANAGER_GET_CLASS(ui_manager->gtk_ui_manager()));
}

Gtk::UIManagerSignals::~UIManagerSignals()
{
}

void 
Gtk::UIManagerSignals::on_add_widget(Widget& widget)
{
	GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(instance_);
	if (g_class->add_widget)
		g_class->add_widget((GtkUIManager*)instance_, widget.gtk_widget());
}
	
void
Gtk::UIManagerSignals::on_actions_changed()
{
	GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(instance_);
	if (g_class->actions_changed)
		g_class->actions_changed((GtkUIManager*)instance_);
}
	
void
Gtk::UIManagerSignals::on_connect_proxy(Action& action, Widget& proxy)
{
	GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(instance_);
	if (g_class->connect_proxy)
		g_class->connect_proxy((GtkUIManager*)instance_, action.gtk_action(), proxy.gtk_widget());
}
	
void
Gtk::UIManagerSignals::on_disconnect_proxy(Action& action, Widget& proxy)
{
	GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(instance_);
	if (g_class->disconnect_proxy)
		g_class->disconnect_proxy((GtkUIManager*)instance_, action.gtk_action(), proxy.gtk_widget());
}
	
void
Gtk::UIManagerSignals::on_pre_activate(Action& action)
{
	GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(instance_);
	if (g_class->pre_activate)
		g_class->pre_activate((GtkUIManager*)instance_, action.gtk_action());
}
	
void
Gtk::UIManagerSignals::on_post_activate(Action& action)
{
	GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(instance_);
	if (g_class->post_activate)
		g_class->post_activate((GtkUIManager*)instance_, action.gtk_action());
}

/*  Gtk::UIManagerClass
 */

void
Gtk::UIManagerClass::init(GtkUIManagerClass *g_class)
{
	g_class->add_widget = &add_widget_proxy;
	g_class->actions_changed = &actions_changed_proxy;
	g_class->connect_proxy = &connect_proxy_proxy;
	g_class->disconnect_proxy = &disconnect_proxy_proxy;
	g_class->pre_activate = &pre_activate_proxy;
	g_class->post_activate = &post_activate_proxy;
}

GtkUIManagerClass*
Gtk::UIManagerClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_UI_MANAGER_GET_CLASS(instance));
	return static_cast<GtkUIManagerClass*>(ptr);
}

GType
Gtk::UIManagerClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_UI_MANAGER);
	}
	return type;
}

void*
Gtk::UIManagerClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::UIManagerClass::add_widget_proxy(GtkUIManager *merge, GtkWidget *widget)
{
	void *ptr = g_object_get_qdata((GObject*)merge, G::ObjectSignals::quark());
	if (ptr)
		static_cast<UIManagerSignals*>(ptr)->on_add_widget(*G::Object::wrap<Widget>(widget));
	else
	{
		GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(merge);
		if (g_class->add_widget)
			g_class->add_widget(merge, widget);
	}
}
	
void
Gtk::UIManagerClass::actions_changed_proxy(GtkUIManager *merge)
{
	void *ptr = g_object_get_qdata((GObject*)merge, G::ObjectSignals::quark());
	if (ptr)
		static_cast<UIManagerSignals*>(ptr)->on_actions_changed();
	else
	{
		GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(merge);
		if (g_class->actions_changed)
			g_class->actions_changed(merge);
	}
}
	
void
Gtk::UIManagerClass::connect_proxy_proxy(GtkUIManager *merge, GtkAction *action, GtkWidget *proxy)
{
	void *ptr = g_object_get_qdata((GObject*)merge, G::ObjectSignals::quark());
	if (ptr)
		static_cast<UIManagerSignals*>(ptr)->on_connect_proxy(*G::Object::wrap<Action>(action),
		                                                      *G::Object::wrap<Widget>(proxy));
	else
	{
		GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(merge);
		if (g_class->connect_proxy)
			g_class->connect_proxy(merge, action, proxy);
	}
}
	
void
Gtk::UIManagerClass::disconnect_proxy_proxy(GtkUIManager *merge, GtkAction *action, GtkWidget *proxy)
{
	void *ptr = g_object_get_qdata((GObject*)merge, G::ObjectSignals::quark());
	if (ptr)
		static_cast<UIManagerSignals*>(ptr)->on_disconnect_proxy(*G::Object::wrap<Action>(action),
		                                                         *G::Object::wrap<Widget>(proxy));
	else
	{
		GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(merge);
		if (g_class->disconnect_proxy)
			g_class->disconnect_proxy(merge, action, proxy);
	}
}
	
void
Gtk::UIManagerClass::pre_activate_proxy(GtkUIManager *merge, GtkAction *action)
{
	void *ptr = g_object_get_qdata((GObject*)merge, G::ObjectSignals::quark());
	if (ptr)
		static_cast<UIManagerSignals*>(ptr)->on_pre_activate(*G::Object::wrap<Action>(action));
	else
	{
		GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(merge);
		if (g_class->pre_activate)
			g_class->pre_activate(merge, action);
	}
}
	
void
Gtk::UIManagerClass::post_activate_proxy(GtkUIManager *merge, GtkAction *action)
{
	void *ptr = g_object_get_qdata((GObject*)merge, G::ObjectSignals::quark());
	if (ptr)
		static_cast<UIManagerSignals*>(ptr)->on_post_activate(*G::Object::wrap<Action>(action));
	else
	{
		GtkUIManagerClass *g_class = UIManagerClass::get_parent_class(merge);
		if (g_class->post_activate)
			g_class->post_activate(merge, action);
	}
}

