/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  viewportsignals.cc - Gtk::Viewport virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "viewport.hh"
#include "viewportsignals.hh"
#include "private/viewportclass.hh"

using namespace GFC;

/*  Gtk::ViewportSignals
 */

Gtk::ViewportSignals::ViewportSignals(Viewport *viewport)
: ContainerSignals(viewport)
{
	Gtk::ViewportClass::init(GTK_VIEWPORT_GET_CLASS(viewport->gtk_viewport()));
}

Gtk::ViewportSignals::~ViewportSignals()
{
}

void
Gtk::ViewportSignals::on_set_scroll_adjustments(Adjustment *hadjustment, Adjustment *vadjustment)
{
	GtkViewportClass *g_class = ViewportClass::get_parent_class(instance_);
	if (g_class->set_scroll_adjustments)
		g_class->set_scroll_adjustments((GtkViewport*)instance_, *hadjustment, *vadjustment);
}

/*  Gtk::ViewportClass
 */

void
Gtk::ViewportClass::init(GtkViewportClass *g_class)
{
	g_class->set_scroll_adjustments = &set_scroll_adjustments_proxy;
}

GtkViewportClass*
Gtk::ViewportClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_VIEWPORT_GET_CLASS(instance));
	return static_cast<GtkViewportClass*>(ptr);
}

GType
Gtk::ViewportClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_VIEWPORT);
	}
	return type;
}

void*
Gtk::ViewportClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ViewportClass::set_scroll_adjustments_proxy(GtkViewport *viewport, GtkAdjustment *hadjustment, GtkAdjustment *vadjustment)
{
	void *ptr = g_object_get_qdata((GObject*)viewport, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ViewportSignals*>(ptr)->on_set_scroll_adjustments(G::Object::wrap<Gtk::Adjustment>(hadjustment),
		                                                              G::Object::wrap<Gtk::Adjustment>(vadjustment));
	else
	{
		GtkViewportClass *g_class = ViewportClass::get_parent_class(viewport);
		if (g_class->set_scroll_adjustments)
			g_class->set_scroll_adjustments(viewport, hadjustment, vadjustment);
	}
}

