with System; use System;
with Grt.Types; use Grt.Types;
with Grt.Avhpi; use Grt.Avhpi;

package Grt.Vcd is
   type Vcd_Var_Kind is (Vcd_Bad,
                         Vcd_Bool,
                         Vcd_Bit, Vcd_Stdlogic,
                         Vcd_Bitvector, Vcd_Stdlogic_Vector);

   --  Which value to be displayed: effective or driving (for out signals).
   type Vcd_Value_Kind is (Vcd_Effective, Vcd_Driving);

   type Verilog_Wire_Info is record
      Addr : Address;
      Irange : Ghdl_Range_Ptr;
      Kind : Vcd_Var_Kind;
      Val : Vcd_Value_Kind;
   end record;

   procedure Get_Verilog_Wire (Sig : VhpiHandleT;
                               Info : out Verilog_Wire_Info);

   --  Return TRUE if last change time of the wire described by INFO is LAST.
   function Verilog_Wire_Changed (Info : Verilog_Wire_Info;
                                  Last : Std_Time)
                                 return Boolean;

   procedure Register;
end Grt.Vcd;
