// FACTORY.H : the "factory" classes that create target-dependent objects.

// Copyright (C) 2001 Tommi Hassinen, Geoffrey Hutchison.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef FACTORY_H
#define FACTORY_H

/*################################################################################################*/

class class_factory;
class console_class_factory;

#include "errutil.h"
#include "prefs.h"

/*################################################################################################*/

/**	The purpose of this is to "##produce" target-dependent objects. This is a generic
	way to create the objects, whether we need base class or derived class objects.
*/

class class_factory
{
	protected:
	
	public:
	
	class_factory(void) { }
	virtual ~class_factory(void) { }
	
	virtual err_util * ProduceErrUtil(void) = 0;
	virtual prefs * ProducePrefs(void) = 0;
};

/// This class has a private constructor, so you can't use this in the usual way; use the GetInstance() instead.

class console_class_factory : public class_factory
{
	private:
	
	static console_class_factory * instance;
	console_class_factory(void);
	
	public:
	
	~console_class_factory(void);
	static console_class_factory * GetInstance(void);
	
	err_util * ProduceErrUtil(void);	// virtual
	prefs * ProducePrefs(void);		// virtual
};

/*################################################################################################*/

#endif	// FACTORY_H

// eof
