// NOTICE.CPP

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "notice.h"

#include "define.h"

#include <strstream>
using namespace std;

/*################################################################################################*/

#ifdef TARGET1
#define TSTRING "console systems (IS THIS VERSION PARALLEL OR NOT?)"
#endif	// TARGET1

#ifdef TARGET2
#define TSTRING "GLUT"
#endif	// TARGET2

#ifdef TARGET3
#define TSTRING "GNOME"
#endif	// TARGET3

/*################################################################################################*/

const char * get_copyright_notice_line(int line)
{
	static char buffer[256];
	ostrstream str(buffer, sizeof(buffer));
	
	switch (line)
	{
		case 0:		str << "Ghemical for " << TSTRING << ends; break;
		case 1:		str << "Version " << VERSION << " released on " << RELEASEDATE << ends; break;
		case 2:		str << " " << ends; break;
		case 3:		str << "For more information please visit " << WEBSITE << ends; break;
		case 4:		str << " " << ends; break;
		case 5:		str << "Copyright (C) 1998-2003 Tommi Hassinen and others." << ends; break;
		case 6:		str << " " << ends; break;
		case 7:		str << "OpenBabel Copyright (C) 1998-2003 by OpenEye Scientific and others" << ends; break;
		case 8:		str << "OpenBabel homepage is http://openbabel.sf.net/" << ends; break;
		case 9:		str << " " << ends; break;
		case 10:	str << "MOPAC7 by James J.P. Stewart and others is in Public Domain." << ends; break;
		case 11:	str << "The MOPAC7 based code included in this program is also in Public Domain." << ends; break;
		case 12:	str << " " << ends; break;
		case 13:	str << "MPQC is copyright (C) 1997 by Limit Point Systems, Inc. and others." << ends; break;
		case 14:	str << "The MPQC program homepage is http://aros.ca.sandia.gov/~cljanss/mpqc" << ends; break;
		case 15:	str << " " << ends; break;
		case 16:	str << "This program is free software; you can redistribute it and/or" << ends; break;
		case 17:	str << "modify it under the terms of the GNU General Public License" << ends; break;
		case 18:	str << "as published by the Free Software Foundation; either version 2" << ends; break;
		case 19:	str << "of the License, or any later version." << ends; break;
		case 20:	str << " " << ends; break;
		case 21:	str << "This program is distributed in the hope that it will be useful," << ends; break;
		case 22:	str << "but WITHOUT ANY WARRANTY; without even the implied warranty of" << ends; break;
		case 23:	str << "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the" << ends; break;
		case 24:	str << "GNU General Public License for more details." << ends; break;
		default:	str << ends;
	}
	
	return buffer;
}

void print_full_copyright_notice(ostream & p1)
{
	for (int line = 0;line < COPYRIGHT_NOTICE_LINES;line++)
	{
		p1 << get_copyright_notice_line(line) << endl;
	}	p1 << endl;
}

/*################################################################################################*/

// eof
