// SETUP_QM1_DIALOG.CPP

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "setup_qm1_dialog.h"

#include "filetrans.h"
#include "t3qm1docv.h"
#include "t3docv.h"

#include <gnome.h>

#include <iostream>
#include <strstream>
using namespace std;

/*################################################################################################*/

setup_qm1_dialog::setup_qm1_dialog(void) : glade_dialog("glade/setup_qm1_dialog.glade")
{
	dialog = glade_xml_get_widget(xml, "setup_qm1_dialog");
	if (dialog == NULL) { cout << "setup_qm1_dialog : glade_xml_get_widget() failed!!!" << endl; return; }
	
	// initialize the widgets...
	
	GtkWidget * optmenu = glade_xml_get_widget(xml, "optionmenu1");
	GtkWidget * submenu = gtk_menu_new(); GtkWidget * item;
	
	int eng_index = 0;
	while (qm1_mdl::engtab1[eng_index] != NULL)	// this is for engines...
	{
		item = gtk_menu_item_new_with_label(qm1_mdl::engtab1[eng_index]);
		gtk_widget_show(item); gtk_menu_append(GTK_MENU(submenu), item);
		
		eng_index++;
	}
	
	gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu), submenu);
	
	gnome_qm1_docv * owner = dynamic_cast<gnome_qm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (!owner) cout << "ERROR: cast failed in setup_qm1_dialog ctor." << endl;
	else						// this will set the current engine...
	{
		eng_index = owner->default_eng;
		gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu), eng_index);
	}
	
	char buffer[64];
	GtkWidget * entry_tc = glade_xml_get_widget(xml, "entry_tc");
	
	ostrstream str_tc(buffer, sizeof(buffer));	// this is for total_charge...
	str_tc.setf(ios::showpos); str_tc << owner->GetTotalCharge() << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_tc), buffer);
	
	// connect the handlers...
	
	glade_xml_signal_connect_data(xml, "on_dialog_destroy", (GtkSignalFunc) handler_Destroy, (gpointer) this);
	
	glade_xml_signal_connect_data(xml, "on_button_ok_clicked", (GtkSignalFunc) handler_ButtonOK, (gpointer) this);
	glade_xml_signal_connect_data(xml, "on_button_cancel_clicked", (GtkSignalFunc) handler_ButtonCancel, (gpointer) this);
	
	gnome_dialog_run(GNOME_DIALOG(dialog));		// MODAL
}

setup_qm1_dialog::~setup_qm1_dialog(void)
{
}

void setup_qm1_dialog::handler_Destroy(GtkWidget *, gpointer data)
{
	setup_qm1_dialog * ref = (setup_qm1_dialog *) data;
	cout << "handler_Destroy() : ref = " << ref << endl;
	
	delete ref;	// the object was created with new!!!
}

void setup_qm1_dialog::handler_ButtonOK(GtkWidget *, gpointer data)
{
	setup_qm1_dialog * ref = (setup_qm1_dialog *) data;
	cout << "handler_ButtonOK() : ref = " << ref << endl;

	gnome_qm1_docv * owner = dynamic_cast<gnome_qm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (!owner) cout << "ERROR: cast failed in setup_qm1_dialog::handler_ButtonOK()." << endl;
	else
	{
		// get the total charge...
		
		GtkWidget * entry_tc = glade_xml_get_widget(ref->xml, "entry_tc");
		gchar * buffer = gtk_entry_get_text(GTK_ENTRY(entry_tc));
		
		istrstream istr(buffer, strlen(buffer) + 1);
		i32s value; istr >> value;
		
		owner->SetTotalCharge(value);
		
		// get the engine index, and do the necessary settings...
		
		GtkWidget * optmenu = glade_xml_get_widget(ref->xml, "optionmenu1");
		GtkWidget * submenu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optmenu));
		GtkWidget * item = gtk_menu_get_active(GTK_MENU(submenu));
		
		int index = g_list_index(GTK_MENU_SHELL(submenu)->children, item);
		owner->default_eng = index;
		
		owner->DiscardCurrentEng();
		
		// perform a sanity check to give feedback to user, and don't close dialog if failed...
		// perform a sanity check to give feedback to user, and don't close dialog if failed...
		// perform a sanity check to give feedback to user, and don't close dialog if failed...
		
		if (owner->CheckEngSettings() == false) return;
		
		// report the changed settings to log.
		
		char mbuff1[256];
		ostrstream str1(mbuff1, sizeof(mbuff1));
		str1 << "Changed the Setup for calculations ";
		str1 << "(quantum mechanics";
		str1 << ", engine = " << owner->engtab1[owner->default_eng];
		str1 << ", total charge = ";
		str1.setf(ios::showpos); str1 << value;
		str1 << ")." << endl << ends;
		owner->PrintToLog(mbuff1);
	}
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

void setup_qm1_dialog::handler_ButtonCancel(GtkWidget *, gpointer data)
{
	setup_qm1_dialog * ref = (setup_qm1_dialog *) data;
	cout << "handler_ButtonCancel() : ref = " << ref << endl;
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

/*################################################################################################*/

// eof
