#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

extern GtkWidget *win_main;
extern guint DEFCONTEXT;

int MyStrStr(const char* s1,const char *s2);

void LdCmbDir(void);
void StatusBarMsg(char *s);

void  Quit(void);
void  Translate(void);
void TranslateTo(FILE *pf,char *str, int (*cmpfunc)(const char *,const char *));
void TranslateFrom(FILE *pf,char *str, int (*cmpfunc)(const char *,const char *));
void About(void);

int MyStrStr(const char* s1,const char *s2)
	{
	     if(strstr(s1,s2))
		     return(0);
	     else
		     return(1);
	}

void 
	
Quit(void)
	{
	    gtk_main_quit();
	}


void TranslateTo(FILE *pf,char *str, int (*cmpfunc)(const char *,const char *))
{
	GtkWidget  *txt;   
	char  s[100],tr[200];
	guint l,found=0;
	
        txt=gtk_object_get_data(GTK_OBJECT(win_main), "txt_result");           	
        l=gtk_text_get_length      (GTK_TEXT(txt));
        gtk_text_backward_delete (GTK_TEXT(txt),l);
	
	
	   while (!feof(pf) && (found<100)){ 
               fscanf (pf,"%s\t",s);
		if(s[0]!='#'){
		       fgets(tr,200,pf); 		   
		       tr[strlen(tr)-1]='\0';
		       if (cmpfunc(s,str)==0){			        			       
				gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,s,-1);
				gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL," -> ",-1);
				gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,tr,-1);           
			        gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,"\n",-1);           
				found++;
		     }
                }
       }
       
      if (!found)
           		gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,"Not Found !",-1);
      else
	      if(found>=100)
		       gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,"Too much Found !",-1);
}


void TranslateFrom(FILE *pf,char *str, int (*cmpfunc)(const char *,const char *))
{
	GtkWidget  *txt;   
	char  s[100],tr[200];
	guint l,found=0;
	
        txt=gtk_object_get_data(GTK_OBJECT(win_main), "txt_result");           	
        l=gtk_text_get_length      (GTK_TEXT(txt));
        gtk_text_backward_delete (GTK_TEXT(txt),l);
	
	
	   while (!feof(pf) && (found<100)){ 
               fscanf (pf,"%s\t",s);
		if(s[0]!='#'){
		       fgets(tr,200,pf);             
		       tr[strlen(tr)-1]='\0';	
		       if (cmpfunc(tr,str)==0){			        
				gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,tr,-1);
				gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL," -> ",-1);
				gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,s,-1);           
			        gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,"\n",-1);           			       
				found++;
		     }
                }
       }
       
      if (!found)
           		gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,"Not Found !",-1);
      else
	      if(found>=100)
		       gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,"Too much Found !",-1);
}


void 
Translate(void)
{
	GtkWidget  *wdg;   
	 char *auxp, fname[255];
	 
	 FILE *pf;
	
       StatusBarMsg("translating...");
	
       wdg=gtk_object_get_data(GTK_OBJECT(win_main), "cmb_dictionary");           
       auxp=gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(wdg)->entry));         
	
	sprintf( fname,/*PACKAGE_SOURCE_DIR*/ PACKAGE_DATA_DIR /* "/data/%s" */ "/%s",auxp);
	pf=fopen (fname,"r");
	if (!pf) return;
		
	wdg=gtk_object_get_data(GTK_OBJECT(win_main), "edt_word");           
        auxp=gtk_entry_get_text(GTK_ENTRY(wdg));         	
	
	wdg=gtk_object_get_data(GTK_OBJECT(win_main), "tbt_from");	
	if( !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg)))
	{
		wdg=gtk_object_get_data(GTK_OBJECT(win_main), "rbt_exact");           
	     
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg)))
		   TranslateTo(pf,auxp,strcasecmp);
		else
		    TranslateTo(pf,auxp,MyStrStr);
	}
	else
	{
		wdg=gtk_object_get_data(GTK_OBJECT(win_main), "rbt_exact");           
	     
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg)))
		   TranslateFrom(pf,auxp,strcasecmp);
		else
		    TranslateFrom(pf,auxp,MyStrStr);		
	}
	
	fclose(pf);
		
	StatusBarMsg("translated");
   	
}

void StatusBarMsg(char *s)
{
   static int i=0;
   GtkWidget *sbr;   
   
    sbr=gtk_object_get_data(GTK_OBJECT(win_main), "sbr_main");              
   if(i)
     gtk_statusbar_remove(GTK_STATUSBAR(sbr),DEFCONTEXT,i);      
   
   i=gtk_statusbar_push(GTK_STATUSBAR(sbr),DEFCONTEXT,s);   
	
}


void About(void){
        GtkWidget  *txt;           
        guint l;

        txt=gtk_object_get_data(GTK_OBJECT(win_main), "txt_result");          
        l=gtk_text_get_length      (GTK_TEXT(txt));
        gtk_text_backward_delete (GTK_TEXT(txt),l);

	gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,"       gidic v0.2\n  A.L.Delgado 2001\n",-1);                     
	
}

void
on_hide_toolbar1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   static int status=1;
   GtkWidget *tbr;   
   
   tbr=gtk_object_get_data(GTK_OBJECT(win_main), "hbx_tbr");              
   
   if(status)
      gtk_widget_hide(tbr);      
   else   
      gtk_widget_show(tbr);   
      
   status=!status;

 }


void
on_btn_tbrtrans_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
   Translate();
}


void
on_btn_tbrhelp_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
    About();
}


void
on_btn_tbrexit_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
     Quit();
}


void
on_btn_trans_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   Translate();
}


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   Quit();
}




void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    About();
}


void
on_tbt_from_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *arrr,*arrl;   
	
        
	arrr=gtk_object_get_data(GTK_OBJECT(win_main), "arr_to");              	
	arrl=gtk_object_get_data(GTK_OBJECT(win_main), "arr_from");              	
	
        if(gtk_toggle_button_get_active(togglebutton))
	{
	        gtk_widget_hide(arrr);
		gtk_widget_show(arrl);
      	}else{
	        gtk_widget_hide(arrl);
		gtk_widget_show(arrr);
	}
}


gboolean
on_win_main_delete_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  Quit();
  return FALSE;
}

