extern "C" {
#include "config.h"
#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>
#include <libgimp/gimpimage_pdb.h>
#include "plugin-intl.h"

#include "main.h"
#include "render.h"
#include "texturize.h"
}
#include "graph.h"

#define MAX_CAPACITY 16383//la moiti du plus grand short, (captype est short dans graph.h)
#define REMPLI    1
#define CUT_NORTH 2
#define CUT_WEST  4
#define HAS_CUT_NORTH(r) (r) & CUT_NORTH
#define HAS_CUT_WEST(r)  (r) & CUT_WEST

//||pixel1 - pixel2||^2
//Exprimentalement le carr semble mieux marcher que la norme 2.
inline Graph::captype cost(guchar * pixel1, guchar * pixel2, int channels)
{
  int diff, result = 0;
  for (int c=0; c<channels; c++){
    diff = pixel1[c] - pixel2[c];
    result += diff*diff;
  }
  return (result/24);
  //Il faut diviser au moins par 24 sinon on risque de renvoyer plus que MAX_CAPACITY.
}

inline Graph::captype gradient(guchar * pixel1, guchar * pixel2, int channels)
{
  int diff, result = 0;
  for (int c=0; c<channels; c++){
    diff = pixel1[c] - pixel2[c];
    result += diff*diff;
  }
  return ((Graph::captype) sqrt(result));
}

//si les quatre arguments de edge_weight sont crits dans le code sur deux lignes
//alors les mmes coordonnes de pixels sont sur une mme ligne,
//les mmes images d'origine du pixel sur une mme colonne.
inline Graph::captype edge_weight(int channels,
  guchar * im1_pix1, guchar * im2_pix1,
  guchar * im1_pix2, guchar * im2_pix2)
{
  return((cost(im1_pix1,im2_pix1,channels) + (cost(im1_pix2,im2_pix2,channels)))
       / (gradient(im1_pix1,im1_pix2,channels) + gradient(im2_pix1,im2_pix2,channels) +1));
}

inline void paste_patch_pixel_to_image(
    int width_i, int height_i, int width_p, int height_p,
    int x_i, int y_i, int x_p, int y_p,
    int channels,
    guchar * image, guchar * patch,
    guchar * coupe_h_here, guchar * coupe_v_here){
  int k;
  for (k=0; k<channels; k++)
    image[(y_i*width_i +x_i)*channels +k] = patch[(y_p*width_p +x_p)*channels +k];
  if (y_i<height_i-1 && y_p<height_p-1){
    for(k=0;k<channels;k++)
     coupe_v_here[((y_i+1)*width_i+x_i)*channels+k] = patch[((y_p+1)*width_p+x_p)*channels+k];
  }
  if (x_i<width_i-1 && x_p<width_p-1){
    for(k=0;k<channels;k++)
      coupe_h_here[(y_i*width_i + x_i+1)*channels +k] = patch[(y_p*width_p+x_p+1)*channels+k];
  }
}

void decoupe_graphe(
    int* patch_posn,
    int width_i, int height_i, int width_p, int height_p,
    int channels,
    guchar ** rempli,
    guchar * image, guchar * patch,
    guchar * coupe_h_here, guchar * coupe_h_west,
    guchar * coupe_v_here, guchar * coupe_v_north)
{
////////////////////////////////////////////////////////////////////////////////
//dclaration des variables
  gint k, x_p, y_p, x_i, y_i, nb_sommets, sommet_courant; //compteurs
  Graph * graphe = new Graph(); //le graphe  couper
  Graph::node_id *nodes; //pour stocker les noeuds du graphe  couper
  Graph::node_id node_of_pixel[width_p * height_p];
    //indique  quel noeud correspond un pixel du patch
  for (k=0; k<width_p * height_p; k++) node_of_pixel[k]=NULL;

  Graph::captype poids;//pour calculer le poids d'un arc avant de le dclarer  Graph:add_edge
  Graph::node_id node_sommet_courant;//nodes[sommet_courant]
  guchar r;
  guchar new_r;


////////////////////////////////////////////////////////////////////////////////
//Cration du graphe
  //On compte le nombre de sommets en parcourant
  //la rgion commune au patch et  l'image remplie.

  nb_sommets = 0;
  for(x_i = int_max(0,patch_posn[0]);
      x_i < int_min(patch_posn[0]+width_p,width_i);
      x_i++)
  {
    for(y_i = int_max(0,patch_posn[1]);
        y_i < int_min(patch_posn[1]+height_p,height_i);
        y_i++)
    {
      r = rempli[x_i][y_i];
      if (r)
      {
        nb_sommets++;
        //anciennes coupes:
        if (HAS_CUT_NORTH(r)) nb_sommets++;
        if (HAS_CUT_WEST(r))  nb_sommets++;
      }
    }
  }

  nodes = (Graph::node_id *) malloc(nb_sommets * sizeof(Graph::node_id));
  for (k=0; k<nb_sommets; k++) nodes[k]=NULL;

  //On cre les noeuds et les arcs.
  //Il y a quatre cas.
  //SI UN BUG EST TROUV DANS UN CAS, IL Y EST SANS DOUTE DANS LES AUTRES.
  sommet_courant = 0;


  //Cas du sommet en haut  gauche de (patch \cap image).
  //Le pixel est suppos rempli. (Cf les conditions sur offset_min_*.)
  x_i = int_max(0,patch_posn[0]);
  x_p = x_i - (patch_posn[0]);
  y_i = int_max(0,patch_posn[1]);
  y_p = y_i - (patch_posn[1]);
  //Cration du noeud
  node_sommet_courant = graphe -> add_node();
  nodes[sommet_courant] = node_sommet_courant;
  sommet_courant++;
  node_of_pixel[x_p*height_p + y_p] = node_sommet_courant;
  //Cration de l'arc vers la source
  graphe -> add_tweights(node_sommet_courant, MAX_CAPACITY, 0);


  //Cas o l'on est sur le bord gauche de (patch \cap image)
  for(y_i = 1+ int_max(0,patch_posn[1]);
      y_i < int_min(patch_posn[1]+height_p,height_i);
      y_i++){
    y_p = y_i - (patch_posn[1]);
    if (rempli[x_i][y_i]){
      //Cration du noeud
      node_sommet_courant = graphe -> add_node();
      nodes[sommet_courant] = node_sommet_courant;
      sommet_courant++;
      node_of_pixel[x_p*height_p + y_p] = node_sommet_courant;
      //Cration de l'arc vertical. Le pixel d'au dessus (x_p,y_p-1) est suppos rempli
      poids = edge_weight(channels,
        image+(y_i*width_i +x_i)*channels, patch+(y_p*width_p +x_p)*channels,
        image+((y_i-1)*width_i +x_i)*channels, patch+((y_p-1)*width_p +x_p)*channels);
      graphe -> add_edge(
        node_sommet_courant, node_of_pixel[x_p*height_p + y_p-1],
        poids,poids);
      //Cration de l'arc horizontal. Seulement si on n'est pas au bord de l'image.
      if (x_i != 0) graphe -> add_tweights(node_sommet_courant, MAX_CAPACITY, 0);
    }
    else{//si x_i,y_i n'est pas rempli, il peut y avoir un arc vers le
         //puits pour le noeud au dessus
      if (rempli[x_i][y_i-1])
        graphe -> add_tweights(node_of_pixel[x_p*height_p + y_p-1], 0, MAX_CAPACITY);
    }
  }

  for(x_i = 1+ int_max(0,patch_posn[0]);
      x_i < int_min(patch_posn[0]+width_p,width_i);
      x_i++){
    x_p = x_i - (patch_posn[0]);

    //Cas o l'on est sur le bord haut de (patch \cap image)
    y_i = int_max(0,patch_posn[1]);
    y_p = y_i - (patch_posn[1]);
    if (rempli[x_i][y_i]){
      //Cration du noeud
      node_sommet_courant = graphe -> add_node();
      nodes[sommet_courant] = node_sommet_courant;
      sommet_courant++;
      node_of_pixel[x_p*height_p + y_p] = node_sommet_courant;
      //Cration de l'arc vertical. Seulement si on n'est pas au bord de l'image.
      if (y_i != 0) graphe -> add_tweights(node_sommet_courant, MAX_CAPACITY, 0);
      //Cration de l'arc horizontal
      if (rempli[x_i-1][y_i]){
        poids = edge_weight(channels,
          image+(y_i*width_i +x_i)*channels, patch+(y_p*width_p +x_p)*channels,
          image+(y_i*width_i +x_i-1)*channels, patch+(y_p*width_p +x_p-1)*channels);
        graphe -> add_edge(
          node_sommet_courant, node_of_pixel[(x_p-1)*height_p + y_p],
          poids,poids);
      }
      else{//si x_i-1,y_i n'est pas rempli
        graphe -> add_tweights(node_sommet_courant, 0, MAX_CAPACITY);
      }
    }


    //Cas gnral
    for(y_i = 1+ int_max(0,patch_posn[1]);
        y_i < int_min(patch_posn[1]+height_p,height_i);
        y_i++){
      y_p = y_i - (patch_posn[1]);
      r = rempli[x_i][y_i];
      if (r){
        //Cration du noeud
        node_sommet_courant = graphe -> add_node();
        nodes[sommet_courant] = node_sommet_courant;
        sommet_courant++;
        node_of_pixel[x_p*height_p + y_p] = node_sommet_courant;
        //Cration de l'arc vertical. Le pixel d'au dessus (x_p,y_p-1) est suppos rempli
        if (HAS_CUT_NORTH(r)){
          node_sommet_courant = graphe -> add_node();
          nodes[sommet_courant] = node_sommet_courant;
          sommet_courant++;
          //l'arc vers le puits
          poids = edge_weight(channels,
            image+(y_i*width_i +x_i)*channels, coupe_v_here+(y_i*width_i + x_i)*channels,
            coupe_v_north+(y_i*width_i +x_i)*channels, image+((y_i-1)*width_i +x_i)*channels);
          graphe -> add_tweights(node_sommet_courant, 0, poids);
          //Les deux arcs vers les pixels respectivement haut et bas
          poids = edge_weight(channels,
            coupe_v_here+(y_i*width_i + x_i)*channels, patch+(y_p*width_p +x_p)*channels,
            image+((y_i-1)*width_i +x_i)*channels, patch+((y_p-1)*width_p +x_p)*channels);
          graphe -> add_edge(
            node_sommet_courant, node_of_pixel[x_p*height_p + y_p-1], poids,poids);
          poids = edge_weight(channels,
            image+(y_i*width_i +x_i)*channels, patch+(y_p*width_p +x_p)*channels,
            coupe_v_north+(y_i*width_i +x_i)*channels, patch+((y_p-1)*width_p +x_p)*channels);
          graphe -> add_edge(
            node_sommet_courant, node_of_pixel[x_p*height_p + y_p], poids,poids);
        }
        else{//pas d'ancienne coupe, cas simple
          poids = edge_weight(channels,
            image+(y_i*width_i +x_i)*channels, patch+(y_p*width_p +x_p)*channels,
            image+((y_i-1)*width_i +x_i)*channels, patch+((y_p-1)*width_p +x_p)*channels);
          graphe -> add_edge(
            node_sommet_courant, node_of_pixel[x_p*height_p + y_p-1], poids,poids);
        }
        //Cration de l'arc horizontal
        if (rempli[x_i-1][y_i]){
          if (HAS_CUT_WEST(r)){
            node_sommet_courant = graphe -> add_node();
            nodes[sommet_courant] = node_sommet_courant;
            sommet_courant++;
            //l'arc vers le puits
            poids = edge_weight(channels,
              image+(y_i*width_i +x_i)*channels, coupe_h_here+(y_i*width_i + x_i)*channels,
              coupe_h_west+(y_i*width_i + x_i)*channels, image+(y_i*width_i +x_i-1)*channels);
            graphe -> add_tweights(node_sommet_courant, 0, poids);
            //Les deux arcs vers les pixels respectivement gauche et droite
            poids = edge_weight(channels,
              coupe_h_here+(y_i*width_i + x_i)*channels, patch+(y_p*width_p +x_p)*channels,
              image+(y_i*width_i +x_i-1)*channels, patch+(y_p*width_p +x_p-1)*channels);
            graphe -> add_edge(
              node_sommet_courant, node_of_pixel[(x_p-1)*height_p + y_p], poids,poids);
            poids = edge_weight(channels,
              image+(y_i*width_i +x_i)*channels, patch+(y_p*width_p +x_p)*channels,
              coupe_h_west+(y_i*width_i + x_i)*channels, patch+(y_p*width_p +x_p-1)*channels);
            graphe -> add_edge(
              node_sommet_courant, node_of_pixel[x_p*height_p + y_p], poids,poids);
          }
          else{//pas d'ancienne coupe, cas simple
            poids = edge_weight(channels,
              image+(y_i*width_i +x_i)*channels, patch+(y_p*width_p +x_p)*channels,
              image+(y_i*width_i +x_i-1)*channels, patch+(y_p*width_p +x_p-1)*channels);
            graphe -> add_edge(
              node_sommet_courant, node_of_pixel[(x_p-1)*height_p + y_p], poids,poids);
          }
        }
        else{//si x_i-1,y_i n'est pas rempli, lien vers le puits:
          graphe -> add_tweights(node_sommet_courant, 0, MAX_CAPACITY);
        }
        if (x_p == (width_p-1) && x_i != (width_i-1))
          //source on the right border of (image \cap patch)
          graphe -> add_tweights(node_sommet_courant, MAX_CAPACITY, 0);
      }
      else {//si x_i,y_i n'est pas rempli, il peut y avoir un arc vers le
            //puits pour les noeuds au dessus et  gauche:
        if (rempli[x_i][y_i-1])
          graphe->add_tweights(node_of_pixel[ x_p   *height_p + y_p-1], 0, MAX_CAPACITY);
        if (rempli[x_i-1][y_i])
          graphe->add_tweights(node_of_pixel[(x_p-1)*height_p + y_p  ], 0, MAX_CAPACITY);
      }
    }
  }



////////////////////////////////////////////////////////////////////////////////
//Calcul de la coupe
  graphe -> maxflow();

////////////////////////////////////////////////////////////////////////////////
//mise_a_jour de l'image
  for(x_i = int_max(0, patch_posn[0]);
      x_i < int_min(patch_posn[0]+width_p, width_i);
      x_i++)
  {
    x_p = x_i - (patch_posn[0]);
    for(y_i = int_max(0, patch_posn[1]);
        y_i < int_min(patch_posn[1]+height_p, height_i);
        y_i++)
    {
      y_p = y_i - (patch_posn[1]);
      r = rempli[x_i][y_i];
      if (r){
        if (graphe->what_segment(node_of_pixel[x_p*height_p + y_p]) == Graph::SINK){
          // anciennes coupes
          new_r = REMPLI;
          if (y_p>0){
            node_sommet_courant = node_of_pixel[x_p*height_p + y_p-1];
            if (node_sommet_courant != NULL){
              if (graphe->what_segment(node_sommet_courant) == Graph::SOURCE){//vertical cut
                new_r += CUT_NORTH;
                for (k=0;k<channels;k++)
                  coupe_v_north[(y_i*width_i +x_i)*channels + k]
                    = patch[((y_p-1)*width_p +x_p)*channels +k];
              }
            }
          }
          if (x_p>0){
            node_sommet_courant=node_of_pixel[(x_p-1)*height_p + y_p];
            if (node_sommet_courant != NULL){
              if (graphe->what_segment(node_sommet_courant) == Graph::SOURCE){
                new_r += CUT_WEST;
                for (k=0;k<channels;k++)
                  coupe_h_west[(y_i*width_i +x_i)*channels + k]
                    = patch[(y_p*width_p +x_p-1)*channels +k];
              }
            }
            rempli[x_i][y_i] = new_r;
          }
          paste_patch_pixel_to_image(
            width_i, height_i, width_p, height_p, x_i, y_i, x_p, y_p,
            channels, image, patch,
            coupe_h_here, coupe_v_here);
        }
      }
      else{// (!rempli[x_i][y_i])
        paste_patch_pixel_to_image(
          width_i, height_i, width_p, height_p, x_i, y_i, x_p, y_p,
          channels, image, patch,
          coupe_h_here, coupe_v_here);
        rempli[x_i][y_i] = REMPLI;
      }
    }
  }

////////////////////////////////////////////////////////////////////////////////
//On nettoie tout
  free(nodes);
  delete graphe;

  return;
}
