// $Id: ChildParamList.hh,v 1.11 2003/05/19 07:00:53 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CHILDPARAMLIST_HH
#define CHILDPARAMLIST_HH
#include <config.h>
#include "Tag.hh"
#include <cassert>

class ChildParamList
{  	const Tag *tag;
	
	void test4validity()
	{  assert(tag->Type()=="child" || tag->Type()=="packing");
	}
	bool hasTag(const std::string &t) const throw()
	{  return tag->hasTag(t); }
public:
	// recommended, be careful to not pass a temporary
	ChildParamList(const Tag &t,bool test=true) throw() : tag(&t)
	{ if (test) test4validity(); }

	const Tag *getTagPtr() const { return tag; }
	const Tag &getTag() const { return *tag; }

	void debug() const throw()
	{  tag->debug(); }
	
	bool hasProperty(const std::string &t) const throw();
	const std::string getProperty(const std::string &t,const std::string &def="") const throw();
	bool getBoolProperty(const std::string &t,const bool def=false) const throw()
	{  return Tag::parse_value_def<bool>(getProperty(t),def); }
	int getIntProperty(const std::string &t,const int def=-1) const throw()
	{  return Tag::parse_value_def<int>(getProperty(t),def); }
	float getFloatProperty(const std::string &t,const float def=0) const throw()
	{  return Tag::parse_value_def<float>(getProperty(t),def); }
	
	typedef Tag::const_iterator const_iterator;
	
	const_iterator begin() const 
	{  return tag->begin(); }
	const_iterator end() const
	{  return tag->end(); }
};

#endif
