// $Id: Enums.hh,v 1.11 2001/05/30 06:57:14 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999-2001 Adolf Petig GmbH. & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef ENUMS_HH
#define ENUMS_HH
// namespace glademm

// these enum declares whether a given widget is an internal property of
// it's parent, e.g. clist's labels, dialog's action area, which is created
// implicitely

// + denotes hints which might optimize further calls away

// if you prefer a table:
// name			child		sisters		grandchildren
// ------------------------------------------------------------------
// no_Subwidgets	real		real		?
// not_Subwidget	real		?		?
// all_Subwidgets	internal	internal	?
// is_Subwidget_only	internal	?		real
// is_Subwidget_all	internal	?		internal
// is_Subwidget		internal	?		?

enum Subwidget 
{     no_Subwidgets, // + this widget type has no internal subwidgets
      not_Subwidget, // this is not a subwidget, but there may be others
      		// there can't be internal subwidgets below!
      all_Subwidgets, 
      		// + all descendants are subwidgets, check their children again
      is_Subwidget_only,  
      		// + this is an internal subwidget, but all descendants aren't
      is_Subwidget_all, // + this and all descendants are internal subwidgets
      is_Subwidget, 
      		// this is an internal widget, but check descendants again
      MaxSubwidget=is_Subwidget,
      SW_Unknown,
//      IgnoreButAcceptChildren=is_Subwidget_only,
//      IgnoreButTestChildren=is_Subwidget,
//      IgnoreTree=is_Subwidget_all,
};

enum InternalSelection
{	NoInternal,
	OnlyInternal,
	Internal_Both
};
#endif
