// $Id: button.hh,v 1.17 2003/03/05 11:27:29 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "bin.hh"

class Gtk_Button : public Gtk_Bin
{public:
	typedef Gtk_Bin Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	Gtk_Button(bool base_class_init=true);
	// for gnome_stock buttons
	bool CantMemberConstruct(const Widget &w) const;
	virtual void GCInclude(const Widget &w, CxxFile &f) const;
	virtual void CreatePointer(const Widget &w,CxxFile &f) const;
//	virtual void CreatePointer_Toplevel(const Widget &w,CxxFile &f) const;
	virtual void DestroyPointer(const Widget &w,CxxFile &f) const;
	virtual void ApplyPreferences(Tag &t) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	
	// toolbar button specific features
	virtual void ToolBarElemCreation(const Widget &w, CxxFile &f) const;
	virtual std::string ToolBarElemName(const Widget &w) const;
	virtual void ToolBarElemArgs(const Widget &w, CxxFile &f) const;
	static std::string ToolBarElemPrefix()
	{  return "Gtk::Toolbar_Helpers::";
	}
	virtual void ToolBar_vars(const Widget &w,CxxFile &f) const {}
	
	// images (for icon)
	const Widget get_image(const Widget &w) const;
};
