// $Id: dialog.cc,v 1.34 2003/03/31 14:09:27 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2002  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "dialog.hh"

static Gtk_Dialog Gtk_Dialog;

const std::string Gtk_Dialog::TypeName(const Widget &w) const
{  return GtkPrefix()+"Dialog";
}

const std::string Gtk_Dialog::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"dialog.h";
}

Gtk_Dialog::Gtk_Dialog()
{  Writer["GtkDialog"]=this;
}

Subwidget Gtk_Dialog::IsSubwidget(const Widget &w,const Widget &ch) const
{  const std::string chn(ch.ChildName());
   if (chn=="Dialog:vbox" || chn=="vbox") return is_Subwidget;
   if (chn=="Dialog:action_area" || chn=="action_area") return is_Subwidget_only;
   if (!chn.empty()) {  std::cerr << "Dialog: Unexpected child name '" << chn << "'\n"; }
   return not_Subwidget;
}

const std::string Gtk_Dialog::InternalInstance(const Widget &parent,const Widget &w2) const
{  const std::string chn(w2.ChildName());
   if (chn=="Dialog:vbox" || chn=="vbox") return "get_vbox()->";
   if (chn=="Dialog:action_area" || chn=="action_area") return "get_action_area()->";
   return Parent::InternalInstance(parent,w2);
}

void Gtk_Dialog::AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const
{  Parent::AddChildren(w,f,instance,writer_for_subw,widget_for_subw);

   if (!GTKMM2) return;
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
   		i!=w.end_contained();++i)
   {  if ((*i).Class()!="Placeholder" && (*i).hasProperty("response_id"))
      {  f.Statement() << instance << "add_action_widget"
      		<< '(' << Reference(*i) << ", "
      		<< (*i).getIntProperty("response_id") << ')';
      }
   }
}

void Gtk_Dialog::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   if (GTKMM2) WriteBoolProperty(w,f,instance, "has_separator");
}
