// $Id: gnome_entry.cc,v 1.8 2002/12/19 13:22:50 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "combo.hh"
#include <iostream>

class Gnome_Entry : public Gtk_Combo
{public:
	typedef Gtk_Combo Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_Entry();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	Subwidget IsSubwidget(const Widget &w,const Widget &ch) const;
	const std::string InternalInstance(const Widget &parent,const Widget &w2) const;
};

static Gnome_Entry Gnome_Entry;

const std::string Gnome_Entry::TypeName(const Widget &w) const
{  return GnomeUIPrefix()+"Entry";
}

const std::string Gnome_Entry::IncludeName(const Widget &w) const
{  return Configuration.GnomeUImmIncludePath()+"entry.h";
}

Gnome_Entry::Gnome_Entry()
{  Writer["GnomeEntry"]=this;
}

void Gnome_Entry::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteIntProperty(w,f,instance, "max_saved");
}

Subwidget Gnome_Entry::IsSubwidget(const Widget &w,const Widget &ch) const
{  if (ch.ChildName()=="GnomeEntry:entry") return is_Subwidget_only;
   else std::cout << "Gnome_Entry::IsSubwidget(" << ch.ChildName() << ")\n";
   return not_Subwidget;
}

const std::string Gnome_Entry::InternalInstance(const Widget &parent,const Widget &w2) const
{  if (w2.ChildName()=="GnomeEntry:entry") return "get_entry()->";
   return Parent::InternalInstance(parent,w2);
}
   
